<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profil extends CI_Controller {
	public function __construct() {
		parent::__construct();
		cek_login();
	}

	public function index() {
		$conf = [
			'title' => 'UpdateProfil'
		];
		
		$this -> layout -> load('layout', 'profil', $conf);
	}

	public function sandi() {
		$conf = [
			'title' => 'Update kata sandi'
		];
		
		$this -> layout -> load('layout', 'sandi', $conf);
	}

	public function aktivitas() {
		$conf = [
			'title' => 'Aktivitas saya'
		];
		
		$this -> layout -> load('layout', 'aktivitas/index', $conf);
	}
	
	public function load_aktivitas() {
		$conf['input'] = $_POST;
		
		$this -> load -> view('aktivitas/data', $conf);
	}

	public function update() {
		$id    = $this -> session -> mart_id;
		$input = $this -> input -> post(null, TRUE);
		$this -> db -> update('admin', $input, ['id' => $id]);
		
		$set['mart_email'] = $input['email'];
		$set['mart_nama']  = $input['nama'];
		$this -> session -> set_userdata($set);

		echo json_encode(['success' => 1]); 
	}

	public function update_sandi() {
		$id    = $this -> session -> mart_id;
		$input = $this -> input -> post(null, TRUE);
		
		if($input['password']) {
			$input['password'] = password_hash($input['password'], PASSWORD_DEFAULT);
			$this -> db -> update('admin', $input, ['id' => $id]);
			echo json_encode(['success' => 1]); 
			exit;
		}
		
		echo json_encode(['success' => 0]); 
	}

	public function logout() {
		$unset = ['mart_id', 'mart_nama', 'mart_level', 'mart_toko'];
		$this -> session -> unset_userdata($unset);

		redirect('login');
		exit;
	}
}

// Controller Profil
// Kode ini dibuat dan dikembangkan oleh codelingker