<div class="page_title d-flex justify-content-between align-items-start flex-wrap">
    <div>
        <h2>Transaksi</h2>
        <p>Penjualan Barang</p>
    </div>
    <div>
        <button class="btn bg-white" data-bs-toggle="modal" data-bs-target="#modal_shortcut">
            <i class="fa fa-keyboard me-1"></i>
            Shortcut
        </button>
    </div>
</div>

<div class="card mb-2">
    <div class="card-body d-flex justify-content-between align-items-start flex-wrap">
        <div class="dropdown mb-2">
            <a href="javascript:void(0)" class="btn border px-3 dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fa fa-plus me-1"></i>
                Barang
            </a>
            <ul class="dropdown-menu py-0">
                <li><h6 class="dropdown-header">Aksi</h6></li>
                <li>
                    <button class="dropdown-item py-2 text-primary" onclick="data_brg(1)">
                        <i class="fa fa-search me-2"></i>
                        Cari Barang
                    </button>
                    <button class="dropdown-item py-2 text-success" onclick="open_scanner('kamera')">
                        <i class="fa fa-camera me-2"></i>
                        Scan dengan Kamera
                    </button>
                    <button class="dropdown-item py-2 text-danger" onclick="open_scanner('scanner')">
                        <i class="fa fa-qrcode me-2"></i>
                        Scan dengan Scanner
                    </button>
                    
                </li>
            </ul>
        </div>
        
        <div >
            <input type="search" id="add_by_kode"
                    class="form-control" placeholder="Kode Barang"
            >
        </div>
    </div>
</div>

<div class="d-flex flex-wrap align-items-start justify-content-between cart_group">
    <div class="card cart_list">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered mb-0">
                    <thead>
                        <tr class="table-light">
                            <th></th>
                            <th>Item</th>
                            <th class="text-center">Qty</th>
                            <th class="text-center w-px-120">Satuan</th>
                            <th class="text-end w-px-150">Harga</th>
                        </tr>
                    </thead>
                    <tbody id="load_data">
                        <tr>
                            <td colspan="5">
                                <div class="text-center">
                                    Belum ada item
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="form_pembayaran">
        <div class="card with-icon mb-2">
            <div class="card-body">
                <p class="mb-1">Total Belanja</p>
                <h4 class="text-danger">0</h4>
                <div class="card-icon d-flex">
                    <i class="fa fa-rupiah-sign"></i>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <button class="btn btn-primary w-100 mb-2 disabled" id="btn_bayar">
                    <strong>
                        Bayar
                    </strong>
                </button>
                <button class="btn btn-danger w-100 disabled">
                    <strong>
                        Bersihkan
                    </strong>
                </button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="modal_plg">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content border-0">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Pelanggan
                        </strong>
                    </h5>
                    <small>
                        List Pelanggan
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body p-0">
                <div class="px-3 pt-3">
                    <div class="row justify-content-between mb-2">
                        <div class="col-sm-2 mb-2">
                            <select class="form-select w-px-80 select2-nosrc" id="limiter_plg">
                                <option>10</option>
                                <option selected>25</option>
                                <option>50</option>
                                <option>100</option>
                            </select>
                        </div>
                        <div class="col-sm-4 mb-2">
                            <div class="input-group">
                                <input type="search" id="pencarian_plg"
                                        placeholder="Cari Barang" 
                                        class="form-control"
                                >
                            </div>
                        </div>
                    </div>
                </div>

                <div id="list_data_plg">
                    
                </div>
            </div>
        </div>
    </div>
</div>

<form method="POST" class="modal fade" id="modal_add_plg">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Pelanggan
                        </strong>
                    </h5>
                    <small>
                        Tambah pelanggan
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>

            <div class="modal-body">                         
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Nama pelanggan </strong>
                        <small class="text-muted">
                            Masukan nama pelanggan
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="nama_plg" 
                        >
                    </div>
                </div>
            
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">No Telp</strong>
                        <small class="text-muted">
                            Masukan no telp / hp pelanggan
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="nohp_plg" 
                        >
                    </div>
                </div>
            
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Alamat </strong>
                        <small class="text-muted">
                            Masukan alamat pelanggan
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="alamat_plg" 
                        >
                    </div>
                </div>
            
            </div>
            
            <div class="modal-footer border-0">
                <button class="btn btn-primary px-4 btn_submit_plg">
                    Simpan
                </button>
                <a href="javascript:void(0)" 
                   class="btn btn-light" 
                   data-bs-dismiss="modal"
                >
                    Batal
                </a>
            </div>
        </div>
    </div>
</form>

<div class="offcanvas offcanvas-end" tabindex="-1" id="lanjut_bayar">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title">Pembayaran</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="card border with-icon mb-3">
            <div class="card-body">
                <p class="mb-1">Total Belanja</p>
                <h4 class="text-danger total_bayar_text">0</h4>
                <div class="card-icon d-flex">
                    <i class="fa fa-dollar-sign"></i>
                </div>
            </div>
        </div>

        <div class="card border with-icon mb-4">
            <div class="card-body">
                <p class="mb-1">Kembalian</p>
                <h4 class="text-warning kembalian_text">0</h4>
                <div class="card-icon d-flex">
                    <i class="fa fa-dollar-sign"></i>
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Pelanggan</label>
            <input type="hidden" value="0" id="id_plg_inp" >
            <div class="input-group">
                <input type="text" value="Umum" disabled class="form-control" id="nama_plg_inp">
                <div class="dropdown">
                    <a href="javascript:void(0)" class="btn btn-light border border-radius-end" data-bs-toggle="dropdown">
                        <i class="fa fa-search"></i>
                    </a>
                    <ul class="dropdown-menu py-0">
                        <li><h6 class="dropdown-header">Aksi</h6></li>
                        <li>
                            <button class="dropdown-item py-2 text-primary" onclick="data_plg(1)">
                                <i class="fa fa-search me-2"></i>
                                Cari pelanggan
                            </button>
                            <button class="dropdown-item py-2 text-success" onclick="modal_add_plg()">
                                <i class="fa fa-plus me-2"></i>
                                Pelanggan Baru
                            </button>
                            <button class="dropdown-item py-2 text-danger" onclick="reset_plg()">
                                <i class="fa fa-user me-2"></i>
                                Pelanggan Umum
                            </button>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="mb-3">
            <label class="form-label">
                Diskon
                <small class="fa fa-info-circle"
                        data-bs-toggle="tooltip"
                        data-bs-html="true"
                        title="
                            <ul class='m-0 p-0 ps-3'>
                                <li class='text-start'> Diskon < 100 dihitung persen </li>
                                <li class='text-start'> Diskon >= 100 dihitung rupiah </li>
                            </ul>
                        "
                ></small>
            </label>
            <div class="input-group">
                <div class="input-group-text">
                    Rp
                </div>
                <input type="text" 
                        class="form-control form_uang fw-bold" 
                        placeholder="0"
                        id="diskon_inp"
                        onchange="hitung_kembalian()"
                >
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Tunai</label>
            <div class="input-group">
                <div class="input-group-text">
                    Rp
                </div>
                <input type="text" 
                        class="form-control form_uang fw-bold" 
                        placeholder="0"
                        id="tunai_inp"
                        onchange="hitung_kembalian()"
                >
            </div>
            <div class="mt-2 shorcut_nominal">
                <button onclick="shortcut_nominal(10000)">10.000</button>
                <button onclick="shortcut_nominal(20000)">20.000</button>
                <button onclick="shortcut_nominal(50000)">50.000</button>
                <button onclick="shortcut_nominal(70000)">70.000</button>
                <button onclick="shortcut_nominal(100000)">100.000</button>
            </div>
        </div>

        <div class="form-check">
            <input class="form-check-input" type="checkbox" id="cetak_struk" checked>
            <label class="form-check-label" for="cetak_struk">
                Cetak struk
            </label>
        </div>

        <div class="mt-5">
            <button class="btn btn-primary w-100 py-3 disabled btn_simpan_jual">
                <strong>
                    Simpan
                </strong>
            </button>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="modal_barang">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content border-0">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        List Barang
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body p-0">
                <div class="px-3 pt-3">
                    <div class="row justify-content-between mb-2">
                        <div class="col-sm-2 mb-2">
                            <select class="form-select w-px-80 select2-nosrc" id="limiter">
                                <option>10</option>
                                <option selected>25</option>
                                <option>50</option>
                                <option>100</option>
                            </select>
                        </div>
                        <div class="col-sm-4 mb-2">
                            <div class="input-group">
                                <input type="search" id="pencarian"
                                        placeholder="Cari Barang" 
                                        class="form-control"
                                >
                            </div>
                        </div>
                    </div>
                </div>

                <div id="list_data_brg">
                    
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_scanner">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan scanner
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body text-center">
                <div class="border p-4 bg-light rounded">
                    <img src="<?= base_url('assets/img/scanner.png') ?>">
                    <div class="mt-3" style="position: relative;overflow:hidden">
                        Arahkan scanner ke barcode
                    </div>
                </div>
                <div class="form-check text-start mt-3">
                    <input type="text" id="inp_scanner" inputmode="none">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_modal">
                    <label class="form-check-label" for="autoclose_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_cek">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Cek Barang
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                 <div class="border p-4 bg-light text-center rounded sec_1">
                    <img src="<?= base_url('assets/img/scanner.png') ?>">
                    <div class="mt-3" style="position: relative;overflow:hidden">
                        Arahkan scanner ke barcode
                    </div>
                </div>
                <div class="sec_2"></div>
                <input type="text" style="position:absolute;left:0;top:0;z-index:-1" id="inp_cek_scan" autocomplete="off">
            </div>
            <div class="modal-footer"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_shortcut">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Shortcut
                        </strong>
                    </h5>
                    <small>
                        
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body bg-light">
                <ul class="list-group">
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Menampilkan list barang yang tersedia
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F1
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Scan kode barang dengan kamera
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F2
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Scan kode barang dengan scanner
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F3
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Input kode barang
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F4
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Masuk mode pembayaran
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F5
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Cek Barang
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F6
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Bayar Transaksi
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                ENTER
                            </h5>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {
        load_data();
    });

    $(document).on('shown.bs.modal', '#modal_cek', function() {
        $('#inp_cek_scan').focus().blur(function() {
            $(this).focus();
        });
    });

    $(document).on('change', '#inp_cek_scan', function() {
        let code = $(this).val();

        $.post({
            url: base_url + 'proses/cek_data',
            data: {code:code},
            dataType: 'json',
            success: (json) => {
                $('#inp_cek_scan').val('');
                if(json.success == 1) {
                    let html = `
                        <div class="msg success">
                            <small class="fa fa-info-circle me-1"></small>
                            Barang ditemukan
                        </div>
                        <table class="table table-sm border border-top">
                            <tr class="text-center table-light">
                                <td colspan="3" class="py-3">
                                    <strong>Detail Barang</strong>
                                </td>
                            </tr>
                            <tr>
                                <td class="w-px-100">Kode</td>
                                <td class="w-px-20">:</td>
                                <td>${json.data.kode}</td>
                            </tr>
                            <tr>
                                <td>Nama</td>
                                <td>:</td>
                                <td>${json.data.nama}</td>
                            </tr>
                            <tr>
                                <td>Stok</td>
                                <td>:</td>
                                <td>${json.data.satuan[0].stok} ${json.data.satuan[0].satuan}</td>
                            </tr>
                            <tr>
                                <td>Harga</td>
                                <td>:</td>
                                <td>${form_uang(json.data.satuan[0].harga_jual)}</td>
                            </tr>
                        </table>
                    `;

                    if(json.data.satuan.length > 1) {
                        let element = `
                            <table class="table table-sm border border-top">
                                <tr>
                                    <th>Satuan</th>
                                    <th class="text-center">Stok</th>
                                    <th>Harga</th>
                                </tr>
                        `;
                        for (let index = 0; index < json.data.satuan.length; index++) {
                            element += `
                                <tr>
                                    <td>${json.data.satuan[index].satuan}</td>
                                    <td class="text-center">${json.data.satuan[index].stok}</td>
                                    <td>${form_uang(json.data.satuan[index].harga_jual)}</td>
                                </tr>
                            `;                            
                        }

                        element += '</table>';
                        html += element;

                    }

                    $('#modal_cek .sec_1').addClass('d-none');
                    $('#modal_cek .sec_2').html(html);
                    $('#modal_cek .modal-footer').html(`
                        <button class="btn btn-primary" onclick="add_brg_list(${json.data.kode});$('#modal_cek').modal('hide')">
                            Tambah keranjang
                        </button>
                    `);

                    console.log(json);

                } else {
                    toast({
                        icon: 'error',
                        title: json.msg
                    })
                }
            }
        })
    })

    function load_data() {
        $.post({
            url: base_url + 'proses/load_data_jual',
            success: data => {
                $('.cart_group').html(data);
                select2();
                tooltip();
                hitung_kembalian();
            }
        })
    }

    function data_brg(page) {
        $.post({
            url: base_url + 'proses/load_list_brg',
            data: {
                cari: $('#pencarian').val(),
                limit: $(document).find('#limiter').val(),
                active: page,
            },
            success: data => {
                $('#modal_barang').modal('show')
                                  .find('#list_data_brg')
                                  .html(data)
                ;

                select2();
               
            }
        });
    } 

    function add_brg_list(kode, type) {
        $.post({
            url: base_url + 'proses/select_item_jual',
            data: {kode:kode},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    load_data();

                    if(json.msg == 'tersedia') {
                        toast({
                            icon: 'info',
                            title: 'Keranjang sudah diupdate'
                        });
                        $('#add_by_kode').val('');

                    } else {
                        toast({
                            icon: 'success',
                            title: json.msg
                        });
                        
                        $('#add_by_kode').val('');
                    }

                } else {
                    toast({
                        icon: 'error',
                        title: json.msg
                    });
                }

                if(type == 'scanner') {
                    $('#inp_scanner').val('');
                }

                if($('#autoclose_modal, #autoclose_cam_modal').is(':checked')) {
                    $('.modal').modal('hide');
                }
            }
        })
    }
    
    function cek_data(code, mode) {
        $.post({
            url: base_url + 'proses/cek_data',
            data: {code:code},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    $('#add_by_kode').val(code).change().val('');

                    if($('.autoclose').is(':checked')) {
                        $('.modal').modal('hide');
                    }

                } else if(json.success == 0) {
                    toast({
                        icon: 'error',
                        title: json.msg
                    });

                }

                if(mode == 'scanner') {
                    $('#inp_scanner').val('');
                }
            }
        })
    }

    function data_plg(page) {
        $.post({
            url: base_url + 'proses/load_list_plg',
            data: {
                cari: $('#pencarian').val(),
                limit: $(document).find('#limiter').val(),
                active: page,
            },
            success: data => {
                $('#modal_plg').modal('show')
                                  .find('#list_data_plg')
                                  .html(data)
                ;
               
            }
        });
    } 

    function modal_add_plg() {
        $('#modal_add_plg').modal('show').trigger('reset');
    }

    function open_scanner(scanner) {
        if(scanner == 'kamera') {
            $('#modal_scan_kamera').modal('show');
        } else {
            $('#modal_scanner').modal('show')
        }
    }

    function hitung_kembalian() {
        let kembalian;
        let total  = $('.total_text').attr('data-total');
        let bayar  = $('#tunai_inp').val().replace(/\./g, '');
        let diskon = $('#diskon_inp').val().replace(/\./g, '');

        diskon    = Number(diskon) >= 100 ? diskon : (Number(total) * Number(diskon)) / 100;
        total     = Number(diskon) > 0 ? Number(total) - Number(diskon) : total; 
        kembalian = Number(bayar) > Number(total) ? Number(bayar) - Number(total) : 0;

        $('.kembalian_text').text(form_uang(String(kembalian)));

        if(Number(bayar) >= Number(total)) {
            $('.btn_simpan_jual').removeClass('disabled');
            return 1;
        } else {
            $('.btn_simpan_jual').addClass('disabled');
            return 0;
        }
    }

    function reset_keranjang() {
        $('#lanjut_bayar input').val('');
        $('#lanjut_bayar #id_plg_inp').val(0);
        $('#lanjut_bayar #nama_plg_inp').val('Umum');
        $('#lanjut_bayar .total_text').text(0).attr('data-total', 0);
        $('.btn_simpan_jual').addClass('disabled').find('strong').text('Simpan');
    }

    function shortcut_nominal(nominal) {
        $('#tunai_inp').val(form_uang(String(nominal))).change();
    }

    function reset_plg() {
        $('#id_plg_inp').val(0);
        $('#nama_plg_inp').val('Umum');
    }

    function show_cek_brg() {
        $('#modal_cek').modal('show')
        $('#modal_cek .sec_1').removeClass('d-none')
        $('#modal_cek .sec_2').html('')
        $('#modal_cek .modal-footer').html('')
    }

    $('#add_by_kode').on('change', function() {
        let kode = $(this).val();
        if(kode != '') {
            add_brg_list(kode, 'input');
            $('#inp_scanner').focus();
        }
    });

    $(document).on('change', '.qty', function() {
        let id   = $(this).data('id');
        let qty  = $(this).val();
        
        $('input, select').attr('disabled', true);
        
        $.post({            
            url: base_url + 'proses/update_qty_jual',
            data: {
                id:id,
                qty: qty
            },
            dataType: 'json',
            success: json => {
                $('input, select').attr('disabled', false);
                load_data();

                if(json.success == 0) {
                    toast({
                        icon: 'error',
                        title: json.msg
                    })
                }
            }
        })
    })

    $(document).on('change', '.id_satuan', function() {
        let id  = $(this).data('id');
        let brg = $(this).data('brg');
        let val = $(this).val();

        $('input, select').attr('disabled', true);

        $.post({
            url: base_url + 'proses/update_satuan_jual',
            data: {
                satuan: val,
                id: id,
                brg:brg
            },
            dataType: 'json',
            success: res => {
                $('input, select').attr('disabled', false);
                load_data();

                if(res.success == 0) {
                    toast({
                        icon: 'error',
                        title: res.msg
                    })
                }
            }
        })
    })

    $(document).on('change', '#pencarian, #limiter', function() {
        data_brg(1);
    })

    $(document).on('click', '#clear_cart', function() {
        swal_hps_item.fire({
            text: 'Aksi ini akan menghapus semua item di keranjang',
            confirmButtonText: 'Bersihkan'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/clean_cart',
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data();
                        }
                    }
                })
            }
        })
    })

    $(document).on('click', '.hps', function() {
        let id = $(this).data('id');

        swal_hps_item.fire({
            text: 'item yang dipilih akan dihapus dari list keranjang'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_item_jual',
                    data: {id:id},
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data();
                        }
                    }
                })
            }
        })
    })

    $(document).on('click', '.qty', function() {
        $(this).select();
    })

    $(document).on('click', '#btn_bayar', function() {
        $('#lanjut_bayar').offcanvas('show');
        let total = $('.total_text').text();
        $('.total_bayar_text').text(total)
    })
    
    $(document).on('click', '.select_item', function() {
        let kode = $(this).data('kode');

        add_brg_list(kode);
    })

    $(document).on('click', '.select_plg', function() {
        let id = $(this).data('id');
        let nama = $(this).data('nama');

        $('#id_plg_inp').val(id);
        $('#nama_plg_inp').val(nama);

        $('.modal').modal('hide');
    })

    $(document).on('change', '#inp_scanner', function() {
        add_brg_list(this.value, 'scanner')
    });

    $(document).on('shown.bs.modal', '#modal_scanner', function() {
        $(document).on('keydown', function(e) {
            if(e.which == 13) {
                $('#inp_scanner').focus();
            }
        })
    })

    $(document).on('submit', '#modal_add_plg', function(e) {
        e.preventDefault();
        let form = $(this);
        $('.btn_submit_plg').addClass('disabled').text('Menyimpan...');
        swal_simpan.fire().then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_plg_jual', 
                    data: form.serialize(),
                    dataType: 'json',
                    success: json => {
                        $('.btn_submit_plg').removeClass('disabled').text('Simpan');

                        if(json.success == 1) {
                            $('.modal').modal('hide').trigger('reset');
                            $('#id_plg_inp').val(json.id);
                            $('#nama_plg_inp').val(json.nama);

                            toast({
                                icon: 'success',
                                title: 'Pelanggan baru ditambahkan'
                            })
                        } else {
                            toast({
                                icon: 'success',
                                title: json.msg
                            })
                        }
                    }
                })
            } else {
                $('.btn_submit_plg').removeClass('disabled').text('Simpan');
            }
        })
    })

    $(document).on('click', '.btn_simpan_jual', function() {
        let form = 'bayar=' + $('#tunai_inp').val() + '&' +
                   'diskon=' + $('#diskon_inp').val() + '&' +
                   'id_plg=' + $('#id_plg_inp').val()
        ;

        // swal_simpan.fire({
        //     text: 'Data keranjang akan disimpan dan dibersihkan',
        //     confirmButtonText: 'Simpan',
        //     focusConfirm: true
        // }).then(res => {
        //     if(res.isConfirmed) {
               
        //     }
        // })

        if(confirm('Apakah anda yakin?')) {
            $.post({
                url: base_url + 'proses/simpan_cart',
                data: form,
                dataType: 'json',
                success: json => {
                    if(json.success == 1) {
                        load_data();
                        reset_keranjang();

                        toast({
                            icon: 'success',
                            title: 'Data keranjang sudah disimpan',
                        });

                        $('.offcanvas').offcanvas('hide');

                        if($('#cetak_struk').is(':checked')) {
                            window.open(json.redirect);
                        }
                    }
                }
            })
        }
    })

    $(document).on('keydown', function(e) {
        switch (e.which) {
            // list barang
            case 112:
                e.preventDefault()
                data_brg(1);       
            break;

            // scan dengan kamera
            case 113:
                e.preventDefault()
                open_scanner('kamera');       
            break;

            // scan dengan scanner
            case 114:
                e.preventDefault()
                open_scanner('scanner');       
            break;

            // Fokus input kode barang 
            case 115:
                e.preventDefault()
                $('#add_by_kode').focus();       
            break;

            // Fokus input kode barang 
            case 116:
                if(!$('#btn_bayar').hasClass('disabled')) {
                    e.preventDefault()
                    $('#btn_bayar').click();
                }
                
                break;
                
            case 117:
                e.preventDefault()
                show_cek_brg()
                
            break;
        }
    })

    $(document).on('shown.bs.offcanvas', '#lanjut_bayar', function() {
        $(this).on('keydown', function(e) {
            switch (e.which) {
                // Fokus input kode barang 
                case 13:
                    if(!$('.btn_simpan_jual').hasClass('disabled') && hitung_kembalian() > 0) {
                        e.preventDefault()
                        $('.btn_simpan_jual').click();
                    }
                    
                break;
            }
        })
    })
</script>

<div class="modal fade" id="modal_scan_kamera">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan kamera
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                <div id="qr-reader" class="w-100 bg-light"></div>
                <div class="form-check text-start mt-3">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_cam_modal">
                    <label class="form-check-label" for="autoclose_cam_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url('assets/vendor/scanner/html5-qrcode.min.js') ?>"></script>
<script>
    var last, count = 0;
    var html5QrcodeScanner = new Html5QrcodeScanner(
        "qr-reader", { fps: 10, qrbox: 250 });

    function success_scan(text, result) {
        if(text !== last) {
            ++count;
            last = text;
            add_brg_list(text, 'scanner');
        }
    }

    $(document).on('shown.bs.modal', '#modal_scan_kamera', function() {
        html5QrcodeScanner.render(success_scan);
    })

    $(document).on('hidden.bs.modal', '#modal_scan_kamera', function() {
        html5QrcodeScanner.clear();
    })
</script>