<div class="page_title d-flex justify-content-between align-items-start flex-wrap">
    <div>
        <h2>Transaksi</h2>
        <p>Pembelian Barang</p>
    </div>

    <div>
        <button class="btn bg-white" data-bs-toggle="modal" data-bs-target="#modal_shortcut">
            <i class="fa fa-keyboard me-1"></i>
            Shortcut
        </button>
    </div>
</div>

<div class="card mb-2">
    <div class="card-body">
        <h5 class="text-warning"><small class="fa fa-info-circle me-1"></small> Penting</h5>
        <p class="mb-0">Perlu diketahui, merubah harga beli per satuan mempengaruhui laporan keuangan anda.</p>
    </div>
</div>

<div class="card mb-2">
    <div class="card-body d-flex justify-content-between align-items-start flex-wrap">
        <div class="dropdown mb-2">
            <a href="javascript:void(0)" class="btn border px-3 dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fa fa-plus me-1"></i>
                Barang
            </a>
            <ul class="dropdown-menu py-0">
                <li><h6 class="dropdown-header">Aksi</h6></li>
                <li>
                    <button class="dropdown-item py-2 text-primary" id="cari_brg">
                        <i class="fa fa-search me-2"></i>
                        Cari Barang
                    </button>
                    <button class="dropdown-item py-2 text-success" onclick="open_scanner('kamera')">
                        <i class="fa fa-camera me-2"></i>
                        Scan dengan Kamera
                    </button>
                    <button class="dropdown-item py-2 text-danger" onclick="open_scanner('scanner')">
                        <i class="fa fa-qrcode me-2"></i>
                        Scan dengan Scanner
                    </button>
                </li>
            </ul>
        </div>

        <div>
            <input type="search" id="add_by_kode"
                    class="form-control" placeholder="Kode barang">
        </div>
    </div>
</div>

<div id="load_data"></div>

<div class="modal fade" tabindex="-1" id="modal_barang">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content border-0">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        List Barang
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body p-0">
                <div class="px-3 pt-3">
                    <div class="row justify-content-between mb-2">
                        <div class="col-sm-2 mb-2">
                            <select class="form-select w-px-80 select2-nosrc" id="limiter">
                                <option>10</option>
                                <option selected>25</option>
                                <option>50</option>
                                <option>100</option>
                            </select>
                        </div>
                        <div class="col-sm-4 mb-2">
                            <div class="input-group">
                                <input type="search" id="pencarian"
                                        placeholder="Cari Barang" 
                                        class="form-control"
                                >
                            </div>
                        </div>
                    </div>
                </div>

                <div id="list_data_brg">
                    
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_scanner">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan scanner
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body text-center">
                <div class="border p-4 bg-light rounded">
                    <img src="<?= base_url('assets/img/scanner.png') ?>">
                    <div class="mt-3" style="position: relative;overflow:hidden">
                        Arahkan scanner ke barcode
                    </div>
                </div>
                <div class="form-check text-start mt-3">
                    <input type="text" id="inp_scanner" inputmode="none">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_modal">
                    <label class="form-check-label" for="autoclose_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_shortcut">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Shortcut
                        </strong>
                    </h5>
                    <small>
                        
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body bg-light">
                <ul class="list-group">
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Menampilkan list barang yang tersedia
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F1
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Scan kode barang dengan kamera
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F2
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Scan kode barang dengan scanner
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F3
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Input kode barang
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F4
                            </h5>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {
        load_data();
    })

    function load_data() {
        $.post({
            url: base_url + 'proses/load_data_beli',
            success: data => {
                $('#load_data').html(data);
                select2();
                tooltip();
            }
        })
    }

    function data_brg(page) {
        $.post({
            url: base_url + 'proses/load_list_brg',
            data: {
                cari: $('#pencarian').val(),
                limit: $(document).find('#limiter').val(),
                active: page,
            },
            success: data => {
                $('#modal_barang').modal('show')
                                  .find('#list_data_brg')
                                  .html(data)
                ;

                select2();
            }
        });
    } 

    function add_brg_list(kode, type) {
        $.post({
            url: base_url + 'proses/select_item_beli',
            data: {kode:kode},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    load_data();

                    if(json.msg == 'tersedia') {
                        toast({
                            icon: 'info',
                            title: 'Keranjang sudah diupdate'
                        });
                        $('#add_by_kode').val('');

                    } else {
                        toast({
                            icon: 'success',
                            title: json.msg
                        });
                        
                        $('#add_by_kode').val('');
                    }

                } else {
                    toast({
                        icon: 'error',
                        title: json.msg
                    });
                }

                if(type == 'scanner') {
                    $('#inp_scanner').val('');
                }

                if($('#autoclose_modal, #autoclose_cam_modal').is(':checked')) {
                    $('.modal').modal('hide');
                }
            }
        })
    }
    
    function reset_beli() {
        swal_hps_item.fire({
            text: 'Anda akan menghapus semua list transaksi',
            confirmButtonText: 'Bersihkan'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/reset_transaksi_beli',
                    success: data => {
                        if(data == '') {
                            load_data();
                        }
                    }
                });
            }
        })
    } 

    function cek_data(code, mode) {
        $.post({
            url: base_url + 'proses/cek_data',
            data: {code:code},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    $('#add_by_kode').val(code).change().val('');

                    if($('.autoclose').is(':checked')) {
                        $('.modal').modal('hide');
                    }

                } else if(json.success == 0) {
                    toast({
                        icon: 'error',
                        title: json.msg
                    });

                }

                if(mode == 'scanner') {
                    $('#inp_scanner').val('');
                }
            }
        })
    }

    function open_scanner(scanner) {
        if(scanner == 'kamera') {            
            $('#modal_scan_kamera').modal('show');

        } else {
            $('#modal_scanner').modal('show')
        }
    }
    
    $(document).on('change', '#pencarian, #limiter', function() {
        data_brg(1);
    })

    $(document).on('change', '.qty', function() {
        let id  = $(this).data('id');
        let val = $(this).val(); 

        $('input, select').attr('disabled', true);

        $.post({
            url: base_url + 'proses/update_qty_beli',
            data: {
                qty: val,
                id: id
            },
            success: res => {
                if(res == '') {
                    load_data();
                    $('input, select').attr('disabled', false);
                }
            }
        })
    });

    $(document).on('change', '.id_satuan', function() {
        let id  = $(this).data('id');
        let val = $(this).val();

        $('input, select').attr('disabled', true);

        $.post({
            url: base_url + 'proses/update_satuan_beli',
            data: {
                satuan: val,
                id: id
            },
            success: res => {
                if(res == '') {
                    load_data();
                    $('input, select').attr('disabled', false);
                }
            }
        })
    })

    $(document).on('change', '.harga_beli', function() {
        let id  = $(this).data('id');
        let val = $(this).val();

        $('input, select').attr('disabled', true);

        $.post({
            url: base_url + 'proses/update_harga_beli',
            data: {
                harga: val,
                id: id
            },
            success: res => {
                if(res == '') {
                    load_data();
                    $('input, select').attr('disabled', false);
                }
            }
        })
    })

    $(document).on('change', '.id_supplier', function() {
        let id  = $(this).data('id');
        let val = $(this).val();

        $('input, select').attr('disabled', true);

        $.post({
            url: base_url + 'proses/update_supplier_beli',
            data: {
                supplier: val,
                id: id
            },
            success: res => {
                if(res == '') {
                    load_data();
                    $('input, select').attr('disabled', false);
                }
            }
        })
    })
   
    $(document).on('change', '#add_by_kode', function() {
        let kode = $(this).val();
        if(kode != '') {
            add_brg_list(kode, 'input');
        }
    })

    $(document).on('click', '.hps', function() {
        let elm = $(this);
        let id  = elm.data('id');

        swal_hps_item.fire({
            text: 'item yang dipilih akan dihapus dari list keranjang'

        }).then(respon => {
            if(respon.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_item_beli',
                    data: {id:id},
                    success: res => {
                        if(res == '') {
                            elm.closest('tr').remove();
                            load_data();
                        }
                    }
                });
            }
        })
    })

    $(document).on('click', '.qty', function() {
        $(this).select();
    })

    $(document).on('click', '#cari_brg', function() {
        data_brg(1);
    })

    $(document).on('click', '.select_item', function() {
        let kode = $(this).data('kode');

        add_brg_list(kode);
    })

    $(document).on('click', '.submit_beli', function() {
        swal_simpan.fire({
            text: 'Pastikan data sudah diisi dengan benar. Data yang sudah disimpan tidak dapat diubah kembali'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_transaksi_beli',
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data();

                            toast({
                                icon: 'success',
                                title: json.msg
                            })
                            
                        } else {
                            toast({
                                icon: 'error',
                                title: json.msg
                            })
                        }
                    }
                })
            }
        })
    })

    $(document).on('change', '#inp_scanner', function() {
        add_brg_list(this.value, 'scanner')
    });

    $(document).on('shown.bs.modal', '#modal_scanner', function() {
        $(document).on('keydown', function(e) {
            if(e.which == 13) {
                $('#inp_scanner').focus();
            }
        })
    })

    $(document).on('keydown', function(e) {
        switch (e.which) {
            // list barang
            case 112:
                e.preventDefault()
                data_brg(1);       
            break;

            // scan dengan kamera
            case 113:
                e.preventDefault()
                open_scanner('kamera');       
            break;

            // scan dengan scanner
            case 114:
                e.preventDefault()
                open_scanner('scanner');       
            break;

            // Fokus input kode barang 
            case 115:
                e.preventDefault()
                $('#add_by_kode').focus();       
            break;
        }
    })

</script>

<div class="modal fade" id="modal_scan_kamera">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan kamera
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                <div id="qr-reader" class="w-100 bg-light"></div>
                <div class="form-check text-start mt-3">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_cam_modal">
                    <label class="form-check-label" for="autoclose_cam_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url('assets/vendor/scanner/html5-qrcode.min.js') ?>"></script>
<script>
    var last, count = 0;
    var html5QrcodeScanner = new Html5QrcodeScanner(
        "qr-reader", { fps: 10, qrbox: 250 });

    function success_scan(text, result) {
        if(text !== last) {
            ++count;
            last = text;
            add_brg_list(text, 'scanner');
        }
    }

    $(document).on('shown.bs.modal', '#modal_scan_kamera', function() {
        html5QrcodeScanner.render(success_scan);
    })

    $(document).on('hidden.bs.modal', '#modal_scan_kamera', function() {
        html5QrcodeScanner.clear();
    })
</script>