<div class="px-3 mb-3">
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="w-px-150">Tanggal</th>
                <th>Barang</th>
                <th class="w-px-80 text-center">Qty</th>
                <th class="w-px-100 text-center">Satuan</th>
                <th class="w-px-150">Jenis</th>
                <th class="w-px-200">Keterangan</th>
            </thead>
            <tbody>
                <?php 
                    $toko       = $this -> session -> mart_toko;
                    $start      = $input['start'];
				    $end       	= $input['end'];
                    $limit      = $input['limit'];
                    $active     = $input['active'];

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $total_data = $this -> db -> get('penjualan_retur') -> num_rows();
    
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                    ];

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $this -> db -> limit($limit, $offset);
                    $this -> db -> order_by('id', 'desc');
                    $data = $this -> db -> get('penjualan_retur') -> result();

                    if($data) :
                        foreach($data as $item) :
                            $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                            $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                            $jenis  = $item -> jenis == 1 ? 'Ganti Baru' : 'Uang Kembali';

                ?>
                    <tr>
                        <td>
                           <?= tgl(date('d M Y',  strtotime($item -> tgl))) ?>
                        </td>
                        <td>
                           <?= $barang -> nama ?>
                        </td>
                        <td class="text-center">
                            <?= $item -> qty ?>                                      
                        </td>
                        <td class="text-center">
                            <?= $satuan -> nama ?>                                      
                        </td>
                        <td>
                            <?= $jenis ?>                                      
                        </td>
                        <td>
                            <?= $item -> ket ?>                                      
                        </td>
                    </tr>
                <?php endforeach ?>
                <?php endif ?>

                <?php if(!empty($cari) && count($data) == 0) : ?>
                    <tr>
                        <td colspan="6">
                            <div class="text-center">
                                Data tidak ditemukan
                            </div>
                        </td>
                    </tr>       
                <?php elseif(count($data) == 0) : ?>  
                    <tr>
                        <td colspan="6">
                            <div class="text-center">
                                Belum ada data
                            </div>
                        </td>
                    </tr>       
                <?php endif ?>  
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>