<div class="modal-header border-0">
    <div>
        <h5 class="modal-header-title mb-0">
            <strong>
                Retur
            </strong>
        </h5>
        <small>
            Retur barang penjualan
        </small>
    </div>
    <a href="javascript:void(0)" 
        class="btn-close" 
        data-bs-dismiss="modal"
    ></a>
</div>
<div class="modal-body">
    <div class="table-responsive">
        <table class="table table-borderless">
            <tbody>
                <tr>
                    <td class="w-px-120">Tanggal</td>
                    <td class="w-px-20">:</td>
                    <td><?= $data -> tgl ?></td>
                </tr>
                <tr>
                    <td class="w-px-120">NOTA</td>
                    <td class="w-px-20">:</td>
                    <td><?= $data -> kode ?></td>
                </tr>
                <tr>
                    <td>Pelanggan</td>
                    <td>:</td>
                    <td><?= $data -> plg ?></td>
                </tr>
            </tbody>
        </table>
        <div class="alert alert-light">
            <strong class="d-block">Petunjuk</strong>
            <ul class="mb-0 px-4">
                <li>Pilih item yang akan di retur</li>
                <li>Pilih jumlah item yang akan di retur</li>
                <li>Pilih jenis retur</li>
                <li>Isi keterangan / alasan barang di retur (optional)</li>
            </ul>
        </div>
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="w-px-50"></th>
                <th>Item</th>
                <th class="w-px-100 text-center">Qty</th>
                <th class="w-px-200">
                    Jenis
                    <small class="fa fa-info-circle"
                            data-bs-toggle="tooltip"
                            data-bs-html="true"
                            title="
                                <ul class='m-0 ps-3 pe-0 text-start'>
                                    <li>
                                        <strong class='d-block'>Ganti Baru:</strong> Barang akan diganti dengan yang baru
                                    </li>
                                    <li>
                                        <strong class='d-block'>Uang kembali:</strong> Uang customer dikembalikan sesuai dengan perjanjian sebelumnya
                                    </li>
                                </ul>
                            "
                    ></small>
                </th>
                <th class="w-px-280">Keterangan</th>
            </thead>
            <tbody>
                <?php if($data -> belanjaan) : ?>
                    <?php foreach($data -> belanjaan as $item) : ?>
                        <?php 
                            $barang   = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row(); 
                            $disabled = $item -> is_retur == 0 ? 'disabled' : null;
                            $is_retur = $item -> is_retur == 0 ? '<strong class="text-danger"><i class="fa fa-info-circle me-1"></i> Barang tidak dapat di retur</strong>' : null;
                        ?>

                            <tr>
                                <td class="text-center">
                                    <div class="d-flex justify-content-center">
                                        <div class="form-check ms-1">
                                            <input type="hidden" name="id[]" value="<?= $item -> id ?>" <?= $disabled ?>>
                                            <input type="hidden" name="id_brg[<?= $item -> id ?>]" value="<?= $item -> id_brg ?>" <?= $disabled ?>>
                                            <input type="hidden" name="id_satuan[<?= $item -> id ?>]" value="<?= $item -> id_satuan ?>" <?= $disabled ?>>
                                            <input class="form-check-input" name="is_retur[<?= $item -> id ?>]" <?= $disabled ?> type="checkbox">
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div style="min-width: 200px"></div>
                                    <?= $item -> barang ?>
                                    <small class="d-block">
                                        <?= $is_retur ?>
                                    </small>
                                </td>
                                <td>
                                    <select name="qty[<?= $item -> id ?>]" class="form-select w-px-100" <?= $disabled ?>>
                                        <?php for($i = 1; $i <= $item -> qty; $i++) : ?>
                                            <option value="<?= $i ?>">
                                                <?= $i ?>
                                            </option>
                                        <?php endfor ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="jenis[<?= $item -> id ?>]" class="form-select w-px-200" <?= $disabled ?>>
                                        <option value="1">Ganti Baru</option>
                                        <option value="2">Uang Kembali</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="text" name="ket[<?= $item -> id ?>]" class="form-control w-px-280" <?= $disabled ?>>
                                </td>
                            </tr>

                    <?php endforeach ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center">
                            Item sudah di retur
                        </td>
                    </tr>
                <?php endif ?>
            </tbody>
        </table>
    </div>
</div>
<?php if($data -> belanjaan) : ?>
    <div class="modal-footer border-0">
        <button class="btn btn-primary px-4">
            Simpan
        </button>
        <a href="javascript:void(0)" class="btn" data-bs-dismiss="modal">
            Batal
        </a>
    </div>
<?php endif ?>