<div class="px-3 mb-3">
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="w-px-50"></th>
                <th>Kode</th>
            </thead>
            <tbody>
                <?php 
                    $toko       = $this -> session -> mart_toko;
                    $admin      = $this -> session -> mart_id;
                    $level      = $this -> session -> mart_level;
                    $start      = $input['start'];
				    $end       	= $input['end'];
                    $limit      = $input['limit'];
                    $active     = $input['active'];

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }
                    
                    if($input['cari']) {
                        $this -> db -> where('kode', $input['cari']);
                    }

                    if($level != 'owner') {
                        $this -> db -> where('id_admin', $admin);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $total_data = $this -> db -> get('penjualan_data') -> num_rows();
    
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                    ];

                    if(!empty($start) AND !empty($end)) {
                        $this -> db -> where('DATE(tgl) >=', $start);
                        $this -> db -> where('DATE(tgl) <=', $end);
                    }

                    if($input['cari']) {
                        $this -> db -> where('kode', $input['cari']);
                    }

                    if($level != 'owner') {
                        $this -> db -> where('id_admin', $admin);
                    }

                    $this -> db -> where('id_toko', $toko);
                    $this -> db -> limit($limit, $offset);
                    $this -> db -> order_by('id', 'desc');
                    $data = $this -> db -> get('penjualan_data') -> result();

                    if($data) :
                        foreach($data as $item) :
                            $total = $this -> app -> get_total_jual($item -> id);
                            $jml   = $this -> app -> get_jml_brg_jual($item -> id);

                ?>
                    <tr>
                        <td class="text-center">
                            <button class="btn" data-bs-toggle="dropdown">
                                <i class="fa fa-ellipsis-v"></i>
                            </button>

                            <ul class="dropdown-menu">
                                <li><h6 class="dropdown-header">Aksi</h6></li>
                                <li>
                                    <button class="dropdown-item py-2 text-success" onclick="detail_riwayat('<?= $item -> id ?>')">
                                        <i class="fa fa-eye me-1"></i> 
                                        Detail
                                    </button>
                                </li>
                                <?php if($jml != '0 Barang') : ?>
                                    <li>
                                        <button class="dropdown-item py-2 text-primary" onclick="cetak_struk('<?= site_url('invoice/penjualan/') . base64_encode($item -> kode) ?>')">
                                            <i class="fa fa-receipt me-1"></i> 
                                            Cetak struk
                                        </button>
                                    </li>
                                    <li>
                                        <button class="dropdown-item py-2 text-danger" onclick="retur_brg('<?= $item -> id ?>')">
                                            <i class="fa fa-box-open me-1"></i> 
                                            Retur Barang
                                        </button>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </td>
                        <td>
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1 pe-3" style="min-width: 200px">
                                    <span class="me-1"><?= $item -> kode ?></span>
                                    <?php if($jml == '0 Barang') : ?>
                                        <span class="text-danger fa fa-info-circle"
                                            data-bs-toggle="tooltip"
                                            title="Semua item sudah di retur"
                                        ></span>
                                    <?php endif ?>
                                    <div>
                                        <small class="text-muted">
                                            <span><?= tgl(date('d M Y H:i', strtotime($item -> tgl))) ?> WIB</span>
                                        </small>
                                    </div>
                                </div>
                                <?php if($jml != '0 Barang') : ?>
                                    <div class="text-end">
                                        <h6 class="text-danger mb-0">
                                            <strong>Rp<?= form_uang($total) ?></strong>
                                        </h6>
                                        <small class="text-muted">
                                            <?= $jml ?> Barang
                                        </small>
                                    </div>
                                <?php endif ?>
                            </div>                                        
                        </td>
                    </tr>
                <?php endforeach ?>
                <?php endif ?>

                <?php if(!empty($cari) && count($data) == 0) : ?>
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Data tidak ditemukan
                            </div>
                        </td>
                    </tr>       
                <?php elseif(count($data) == 0) : ?>  
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Belum ada data
                            </div>
                        </td>
                    </tr>       
                <?php endif ?>  
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>