<div id="table-responsive">
    <table class="table table-borderless table-sm">
        <tbody>
            <?php 
                $data  = $this -> db -> get_where('penjualan_data', ['id' => $input['id']]) -> row(); 
                $admin = $this -> db -> get_where('admin', ['id' => $data -> id_admin]) -> row(); 
                $plg   = $this -> db -> get_where('pelanggan', ['id' => $data -> id_plg]) -> row(); 
                $plg   = $data -> id_plg == 0 ? 'Umum' : (isset($plg -> nama) ? $plg -> nama : '-'); 
            ?>
            <tr>
                <td class="w-px-100">Tanggal</td>
                <td class="w-px-20">:</td>
                <td><?= tgl(date('d M Y H:i', strtotime($data -> tgl))) ?> WIB</td>
            </tr>
            <tr>
                <td class="w-px-100">NOTA</td>
                <td class="w-px-20">:</td>
                <td><?= $data -> kode ?></td>
            </tr>
            <tr>
                <td>Pelanggan</td>
                <td>:</td>
                <td><?= $plg ?></td>
            </tr>
            <tr>
                <td>Kasir</td>
                <td>:</td>
                <td><?= $admin -> nama ?></td>
            </tr>
        </tbody>
    </table>
    <table class="table table-bordered mb-0">
        <thead class="table-light">
            <th>Item</th>
            <th class="text-center  w-px-80">
                Qty
            </th>
            <th class="text-center w-px-120">
                Satuan
            </th>
            <th class="text-end w-px-120">
                Harga Jual
            </th>
            <th class="text-end w-px-150">
                Total Harga
            </th>
        </thead>
        <tbody>
            <?php 
                $this -> db -> where('qty > ', 0);
                $detail = $this -> db -> get_where('penjualan_detail', ['id_jual' => $input['id']]) -> result();
                $total  = 0;

                if($detail) :
                    foreach($detail as $item) :
                        $brg      = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                        $satuan   = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();

                        $subtotal = $item -> qty * $item -> harga_jual;
                        $total   += $subtotal;
            ?>
                <tr>
                    <td>
                        <?= isset($brg -> nama) ? $brg -> nama : '<em>Barang dihapus</em>' ?>
                    </td>
                    <td class="text-center">
                        <?= $item -> qty ?>
                    </td>
                    <td class="text-center">
                        <?= isset($satuan -> nama) ? $satuan -> nama : ''  ?>
                    </td>
                    <td class="text-end">
                        <?= form_uang($item -> harga_jual) ?>
                    </td>
                    <td class="text-end">
                        <?= form_uang($subtotal) ?>
                    </td>
                </tr>
            <?php endforeach ?>               
            
            <tr class="table-light">
                <th></th>
                <th></th>
                <th></th>
                <th class="text-end text-danger">Total Belanja</th>
                <th class="text-end text-danger"><?= form_uang($total) ?></th>
            </tr>
            <tr class="table-light">
                <th></th>
                <th></th>
                <th></th>
                <th class="text-end text-danger">Diskon</th>
                <th class="text-end text-danger"><?= form_uang($data -> diskon) ?></th>
            </tr>
            <tr class="table-light">
                <th></th>
                <th></th>
                <th></th>
                <th class="text-end text-danger">Tunai</th>
                <th class="text-end text-danger"><?= form_uang($data -> bayar) ?></th>
            </tr>
            <tr class="table-light">
                <th></th>
                <th></th>
                <th></th>
                <th class="text-end text-danger">Kembalian</th>
                <th class="text-end text-danger">
                    <?= form_uang($data -> bayar - ($data -> total - $data -> diskon)) ?>
                </th>
            </tr>

            <?php else: ?>
                <tr>
                    <td colspan="5" class="text-center">
                        Semua item di retur
                    </td>
                </tr>
            <?php endif ?>
        </tbody>
    </table>
</div>