<div class="page_title row">
    <div class="col-md-7 mb-2">
        <h2>Riwayat</h2>
        <p>Riwayat Pembelian</p>
    </div>
    <div class="col-md-5">
    <div class="input-group">
            <input type="date" id="filter_start" 
                    class="form-control"
                    data-bs-toggle="tooltip"
                    title="Masukan filter tgl mulai"
                    value="<?= date('Y-m-d', strtotime('-1 month')) ?>"
            >
            <input type="date" id="filter_end" 
                    class="form-control"
                    data-bs-toggle="tooltip"
                    title="Masukan filter tgl selesai"
                    value="<?= date('Y-m-d') ?>"
            >
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card shadow-none" >
            <div class="card-header">
                <div class="row justify-content-between mt-3">
                    <div class="col-sm-2 mb-2">
                        <select class="form-select w-px-80 select2-nosrc" id="limiter">
                            <option>10</option>
                            <option selected>25</option>
                            <option>50</option>
                            <option>100</option>
                        </select>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <input type="search" id="pencarian" 
                                class="form-control"
                                placeholder="Cari Transaksi"
                        >
                    </div>
                </div>
            </div>
            <div class="card-body p-0" id="data">
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_detail">
    <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Riwayat
                        </strong>
                    </h5>
                    <small>
                        Detail riwayat pembelian
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {
        load_data(1);
    })

    function load_data(page) {
        $.post({
            url: base_url + 'proses/load_riwayat_beli',
            data: {
                start: $('#filter_start').val(),
                end: $('#filter_end').val(),
                limit: $('#limiter').val(),
                cari: $('#pencarian').val(),
                active: page,
            },
            dataType: 'html',
            success: data => {
                $('#data').html(data);
            }
        })
    }

    function detail_riwayat(id) {
        $.post({
            url: base_url + 'proses/detail_riwayat_beli',
            data: {id:id},
            success: data => {
                $('#modal_detail').modal('show')
                                    .find('.modal-body')
                                    .html(data)
                ;
            }
        })
    }

    $(document).on('change', '#limiter, #filter_start, #filter_end, #pencarian', function() {
        load_data(1);
    })

</script>