<div class="page_title d-flex justify-content-between align-items-start">
    <div class="flex-grow-1">
        <h2>Pengaturan</h2>
        <p>Umum</p>
    </div>
</div>

<?php if($this -> session -> mart_demo == 0) : ?>
    <form class="card">
        <div class="card-body pt-4">
            <div class="row">
                <div class="col-md-5">
                    <div class="msg warning mb-4">
                        <strong class="d-block">
                            <i class="fa fa-info-circle me-1"></i>
                            Catatan
                        </strong>
                        <ul class="mb-0 mt-2">
                            <li>
                                Hanya mendukung format gambar .png, .jpg, .jpeg 
                            </li>
                            <li>
                            Ukuran gambar maksimal 1 MB 
                            </li>
                        </ul>
                    </div>

                    <div class="dashed rounded px-4 py-5 text-center o-hidden position-relative mb-3">
                        <label for="">
                            <i class="fa fa-upload fa-2x d-block text-muted mb-4"></i>
                            <span>Pilih atau tempelkan file gambar disini</span>
                        </label>
                        <input type="file" id="import_file_inp" name="file" accept=".jpg, .jpeg, .png">
                    </div>

                    <div class="msg light dashed w-100 mart_logo d-flex justify-content-between align-items-start flex-wrap" style="z-index: 1">
                        <div class="img">
                            <img src="<?= base_url('uploads/' . $this -> app -> get_app('logo')) ?>" >
                        </div>
                        <div class="text">
                            <strong class="d-block">Logo Toko</strong>
                            <span class="logo_title">
                                <?= $this -> app -> get_app('logo') ?>
                            </span>
                        </div>
                    </div>

                    <div class="mt-5">
                        <button class="btn btn-primary w-100 py-3 btn_simpan">
                            <strong class="save_text">Simpan</strong>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script>
        $(document).on('change', '#import_file_inp', function() {
            let file = this.files[0];

            if (file) {
                var reader = new FileReader();
                
                reader.onload = function (e) {
                    $('.mart_logo img').attr('src', e.target.result);
                };

                $('.logo_title').text(file.name + (' (' + Math.round(file.size / 1000) +' KB)'));

                reader.readAsDataURL(file);
            }
        })

        $(document).on('submit', 'form', function(e) {
            e.preventDefault();
            let form = this;
            $('.save_text').text('Menyimpan').closest('button').addClass('disabled');
            $.post({
                url: base_url + 'proses/upload_logo', 
                data: new FormData(form),
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(json) {
                    if(json.success == 1) {
                        $('.save_text').text('Memuat ulang...')
                        toast({
                            title: json.msg,
                            icon: 'success',
                        })

                        setTimeout(() => {
                            location.reload();
                        }, 1200);

                    } else {
                        $('.save_text').text('Simpan').closest('button').removeClass('disabled');

                        if(json.msg == 'update-0') {
                            toast({
                                title: 'Tidak ada perubahan',
                                icon: 'info'
                            })

                        } else {
                            toast({
                                title: json.msg,
                                icon: 'error'
                            })
                        }
                    }
                },
                error: function(xhr, status, error) {
                    $('.save_text').text('Simpan').closest('button').removeClass('disabled');
                    toast({
                        title: 'Ada yang salah, coba lagi',
                        icon: 'error'
                    })
                }
            });
        })
    </script>
    
<?php else: ?>
    <div class="msg warning">
        <i class="fa fa-info-circle me-1"></i>
        Halaman ini tidak tersedia untuk akun demo
    </div>
<?php endif ?>