<div class="page_title d-flex justify-content-between align-items-start">
    <div class="flex-grow-1">
        <h2>Pelanggan</h2>
        <p>Data pelanggan</p>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card shadow-none" >
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-start">
                    <div class="card-title">
                        <h5>Data</h5>
                        <small class="text-muted">
                           List pelanggan
                        </small>
                    </div>
                    <button class="btn btn-primary px-3" id="tambah">
                        <i class="fa fa-plus me-1"></i> 
                        Baru
                    </button>
                </div>
                <div class="row justify-content-between mt-3">
                    <div class="col-sm-2 mb-2">
                        <select class="form-select w-px-80 select2-nosrc" id="limiter">
                            <option>10</option>
                            <option selected>25</option>
                            <option>50</option>
                            <option>100</option>
                        </select>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <div class="input-group">
                            <input type="search" id="pencarian"
                                    placeholder="Cari pelanggan" 
                                    class="form-control"
                            >
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body p-0" id="data_brg">
                
            </div>
        </div>
    </div>
</div>

<form method="POST" class="modal fade" id="modal">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Pelanggan
                        </strong>
                    </h5>
                    <small>
                        Tambah pelanggan
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>

            <div class="modal-body">
                <input type="hidden" name="id" value="0">
                         
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Nama pelanggan </strong>
                        <small class="text-muted">
                            Masukan nama pelanggan
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="nama" 
                        >
                    </div>
                </div>
            
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">No Telp</strong>
                        <small class="text-muted">
                            Masukan no hp pelanggan
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="nohp" 
                        >
                    </div>
                </div>
            
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Alamat </strong>
                        <small class="text-muted">
                            Masukan alamat pelanggan
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="alamat" 
                        >
                    </div>
                </div>
            
            </div>
            
            <div class="modal-footer border-0">
                <button class="btn btn-primary px-4">
                    Simpan
                </button>
                <a href="javascript:void(0)" 
                   class="btn btn-light" 
                   data-bs-dismiss="modal"
                >
                    Batal
                </a>
            </div>
        </div>
    </div>
</form>

<script>
    function load_data(active) {
        $.post({
            url: base_url + 'proses/load_pelanggan',
            dataType: 'html',
            data: {
                active: active,
                cari: $('#pencarian').val(),
                limit: $('#limiter').val(),
            },
            success: data => {
                $('#data_brg').html(data);
            }
        })
    }

    function edit(id) {
        $.post({
            url: base_url + 'proses/get_pelanggan',
            data: {id: id},
            dataType: 'json',
            success: json => {
                $('#modal').modal('show');
                $('#modal .modal-header small').text('Edit pelanggan');
                $('[name="id"]').val(json.id);
                $('[name="nama"]').val(json.nama);
                $('[name="nohp"]').val(json.nohp);
                $('[name="alamat"]').val(json.alamat);
            }
        })
    }

    function hps(id, nama) {
        swal_hps_item.fire().then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_pelanggan',
                    data: {
                        id:id,
                        nama:nama
                    },
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data(1);
                        }
                    }
                })
            }
        })
    }

    $(function() {
        load_data(1);
    });
    
    $(document).on('click', '#tambah', function() {
        $('#modal').trigger('reset').modal('show');
        $('#modal .modal-header small').text('Tambah pelanggan');
        $('[name="id"]').val(0);

    });

    $(document).on('change', '#pencarian, #limiter', function() {
        load_data(1);
    });

    $(document).on('submit', 'form', function(e) {
        e.preventDefault();
        let form = $(this);

        swal_simpan.fire().then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/simpan_pelanggan',
                    data: form.serialize(),
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data(1);
                            $('#modal').modal('hide').trigger('reset');
                        }
                    }
                })
            }
        });
    });

    
</script>