<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>

    <meta content="#6475d3" name="msapplication-navbutton-color">
    <meta content="#6475d3" name="apple-mobile-web-app-status-bar-style">
    <meta content="#6475d3" name="theme-color">

    <link rel="shortcut icon" href="<?= base_url('uploads/logo.png') ?>" type="image/x-icon">

    <link rel="stylesheet" href="<?= base_url() ?>assets/vendor/bs/bs.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/vendor/font/fa/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/login.css">
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/mod.css">

    <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
    <script src="<?= base_url() ?>assets/vendor/bs/bs.bundle.min.js"></script>
    <script src="<?= base_url() ?>assets/vendor/sweetalert/sweetalert.all.min.js"></script>
</head>
<body class="o-hidden">
    <div class="loading">
        <div class="text-center">
            <div class="animasi"></div>
            <p class="mt-2 mb-0">
                <strong>
                    Tunggu Bentar        
                </strong>
            </p>
        </div>
    </div>
    <div class="box">
        <div class="header">
            <i class="fa fa-sign-in"></i>
            <h2>
                Login
            </h2>
        </div>
        <form class="body" method="POST">
            <div class="mb-3">
                <label for="" class="form-label">
                    Email
                </label>
                <input type="text" class="form-control" name="email"> 
                <small class="email-error text-danger"></small>
            </div>
            <div class="mb-3">
                <label for="" class="form-label">
                    Kata Sandi
                </label>
                <div class="input-group">
                    <input type="password" class="form-control" name="password"> 
                    <div class="input-group-text cursor-pointer text-muted showhide_pass">
                        <i class="fa fa-eye-slash"></i>
                    </div>
                </div>
                <small class="password-error text-danger"></small>
            </div>
            <div class="mt-5">
                <button class="btn btn-primary btn-lg w-100 login-btn py-3">
                    Login
                </button>
            </div>
            <div class="mt-4 text-center">
                <p class="mb-0">
                    Butuh Bantuan?
                </p>
                <small>
                    <a href="https://wa.me/6282236676620" target="_blank" class="text-decoration-none">Hubungi Admin</a>
                </small>
            </div>
        </form>
    </div>

    <script>
        let base_url = '<?= site_url() ?>';

        function email_error(status, msg) {
            if(status == 1) {
                $('[name="email"]').addClass('is-invalid');
                $('[name="password"]').removeClass('is-invalid');
                $('.email-error').text(msg);
                $('.password-error').text('');
            } else {
                $('[name="email"]').removeClass('is-invalid');
                $('.email-error').text('');
            }
        }

        function password_error(status, msg) {
            if(status == 1) {
                $('[name="password"]').addClass('is-invalid');
                $('[name="email"]').removeClass('is-invalid');
                $('.password-error').text(msg);
                $('.email-error').text('');

            } else {
                $('[name="password"]').removeClass('is-invalid');
                $('.password-error').text('');
            }
        }

        function akun_valid() {
            $('[name="email"], [name="password"]').removeClass('is-invalid');
            $('.email-error, .password-error').text('');

            window.location.href = base_url;
        }

        $(window).on('load', function() {
            $('.loading').fadeOut(function() {
                $('body').removeClass('o-hidden');
            })
        });

        $('.showhide_pass').on('click', function() {
            if($(this).hasClass('show')) {
                $(this).removeClass('show');
                $('[name="password"]').attr('type', 'password');
                $('i', this).removeClass('fa fa-eye').addClass('fa fa-eye-slash');
            } else {
                $(this).addClass('show');
                $('[name="password"]').attr('type', 'text');
                $('i', this).removeClass('fa fa-eye-slash').addClass('fa fa-eye');
            }
        });

        $('form').on('submit', function(e) {
            e.preventDefault();
            let email_msg, password_msg;
            $('.login-btn').text('Memproses...');

            $.post({
                url: base_url + 'login/proses',
                data: $(this).serialize(),
                dataType: 'json',
                success: json => {
                    $('.login-btn').text('Login')
                    if(json.success == 0) {
                        if(json.msg == 'empty-username') {
                            email_msg = 'Username belum diisi';
                            email_error(1, email_msg);
                            
                        } else if(json.msg == 'empty-password') {
                            password_msg = 'Kata sandi belum diisi';
                            password_error(1, password_msg);

                        } else if(json.msg == 'invalid-email') {
                            email_msg = 'Format email salah';
                            email_error(1, email_msg);

                        } else if(json.msg == 'akun-0') {
                            email_msg = 'Akun tidak terdaftar';
                            email_error(1, email_msg);

                        } else if(json.msg == 'invalid-password') {
                            password_msg = 'Kata sandi salah';
                            password_error(1, password_msg);

                        }

                    } else {
                        akun_valid();
                    }
                }
            })
        });
    </script>
</body>
</html>