<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/mod.css') ?>">
    <style>
        body {
            font-size: 16px;
        }
        h3, h6 {
            margin: 0 0 0.6rem;
        }
        h6 {
            font-size: 1rem;
        }
        h3 {
            font-size: calc(1.3rem + .6vw);
        }
        .text-center {
            text-align: center;
        }
        .mb-4 {
            margin-bottom: 1.5rem!important;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="text-center mb-4">
        <h6>
            <strong>Laporan Stok Barang</strong>
        </h6>
        <h3>
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        Bulan <br> <?= tgl(date('F Y')) ?> 
    </div>
    
    <table>
        <thead class="table-light">
            <th class="text-center w-px-150">Kode</th>
            <th class="text-center">Item</th>
            <th class="w-px-100 text-center">Stok</th>
            <th class="w-px-120 text-center">Satuan</th>
        </thead>
        <tbody>
            <?php
                $toko = $this -> session -> mart_toko;

                $this -> db -> select('kode, nama, id_brg, id_satuan, stok, harga_jual');  
                $this -> db -> join('barang_satuan satuan', 'barang.id = satuan.id_brg');
                $this -> db -> where('satuan.id_toko', $toko);
                $this -> db -> order_by('kode', 'DESC');

                $get = $this -> db -> get('barang') -> result();

                foreach($get as $item) :
                    $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
            ?>
            <tr>
                <td>
                    <?= $item -> kode ?>
                </td>
                <td>
                    <?= $item -> nama ?>
                </td>
                <td class="text-center">
                    <?= $item -> stok ?>
                </td>
                <td class="text-center">
                    <?= isset($satuan -> nama) ? $satuan -> nama : '' ?>
                </td>
            </tr>
            <?php endforeach ?>
            
            <?php if(empty($get)) : ?>
                <tr>
                    <td colspan="4" class="text-center">
                        Belum ada item
                    </td>
                </tr>
            <?php endif ?>
        </tbody>
    </table>

    <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
    <script>
        if($(window).width() > 768) {
            setTimeout(function () { window.print(); }, 0);
            window.onload = function () { setTimeout(function () { window.close(); }, 0); }
        } else {
            print();
        }
    </script>
</body>
</html>
