<div class="px-3">
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Retur Barang</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
       
        <?php if($input['start_date'] == date('Y-m-d')) : ?>
            Hari ini
        <?php elseif($input['start_date'] == $input['end_date']) : ?>
            Tanggal <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>
        <?php else: ?>
            Periode <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>  ~ <?= tgl(date('d F Y', strtotime($input['end_date']))) ?>
        <?php endif ?>
    </div>
    
    <div class="table-responsive mb-4">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="text-center w-px-150">Tanggal</th>
                <th class="text-center">Barang</th>
                <th class="w-px-100 text-center">Jumlah</th>
                <th class="w-px-120 text-center">Satuan</th>
                <th class="w-px-150 text-center">Jenis</th>
                <th class="w-px-150 text-center">Keterangan</th>
            </thead>
            <tbody>
                <?php
                    $limit      = $input['limit'];
                    $active     = $input['active'];
                    $toko = $this -> session -> mart_toko;
    
                    $this -> db -> from('penjualan_retur');
                    if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                        $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                        $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                    }
                    $this -> db -> where('id_toko', $toko);                    
                    $total_data = $this -> db -> get() -> num_rows();
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                        'func'       => 'load_data'
                    ];
    
                    $this -> db -> from('penjualan_retur');
                    if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                        $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                        $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                    }
                    $this -> db -> where('id_toko', $toko);
                    $this -> db -> order_by('id', 'DESC');
                    $this -> db -> limit($limit, $offset);
                    $get        = $this -> db -> get() -> result();
                    
                    if($get) :
                        foreach($get as $item) :
                            $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                            $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                            $jenis  = $item -> jenis == 1 ? 'Ganti Baru' : 'Uang Kembali';
                ?>

                    <tr>
                        <td class="text-center">
                            <?= tgl(date('d M Y', strtotime($item -> tgl))) ?>
                        </td>
                        <td>
                            <?= $barang -> nama ?>
                        </td>
                        
                        <td class="text-center">
                            <?= $item -> qty ?>
                        </td>

                        <td class="text-center">
                            <?= $satuan -> nama ?>
                        </td>

                        <td class="text-center">
                            <?= $jenis ?>
                        </td>

                        <td>
                            <?= $item -> ket ?>
                        </td>
                    </tr>

                <?php endforeach ?>
                <?php endif ?>


                <?php if(empty($get)) : ?>
                    <tr>
                        <td colspan="6" class="text-center">
                            Belum ada item
                        </td>
                    </tr>
                <?php endif ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>