<div class="px-3">
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Penjualan</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        
        <?php if($input['start_date'] == date('Y-m-d')) : ?>
            Hari ini
        <?php elseif($input['start_date'] == $input['end_date']) : ?>
            Tanggal <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>
        <?php else: ?>
            Periode <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>  ~ <?= tgl(date('d F Y', strtotime($input['end_date']))) ?>
        <?php endif ?>
    </div>
    
    <div class="table-responsive mb-4">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="text-center w-px-80"></th>
                <th class="text-center w-px-150">Tanggal</th>
                <th class="text-center w-px-150 ">Nota</th>
                <th class="text-center">Pelanggan</th>
                <th class="w-px-120 text-center">Total Belanja</th>
            </thead>
            <tbody>
                <?php
                    $limit      = $input['limit'];
                    $active     = $input['active'];
                    $admin      = $this -> session -> mart_id;
                    $level      = $this -> session -> mart_level;
                    $toko       = $this -> session -> mart_toko;
    
                    $this -> db -> from('penjualan_data data');
                    $this -> db -> join('penjualan_detail detail', 'data.id = detail.id_jual');
                    if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                        $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                        $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                    }
                    if($level != 'owner') {
                        $this -> db -> where('data.id_admin', $admin);
                    }
                    $this -> db -> where('data.id_toko', $toko);
                    $this -> db -> where('qty > ', 0);
                    $this -> db -> group_by('detail.id_jual');                    
                    $total_data = $this -> db -> get() -> num_rows();
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                        'func'       => 'load_data'
                    ];
    
                    $this -> db -> from('penjualan_data data');
                    $this -> db -> join('penjualan_detail detail', 'data.id = detail.id_jual');
                    if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                        $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                        $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                    }
                    if($level != 'owner') {
                        $this -> db -> where('data.id_admin', $admin);
                    }
                    $this -> db -> where('data.id_toko', $toko);
                    $this -> db -> where('qty > ', 0);
                    $this -> db -> order_by('data.id', 'DESC');
                    $this -> db -> limit($limit, $offset);
                    $this -> db -> group_by('detail.id_jual');
                    $total      = 0;
                    $get        = $this -> db -> get() -> result();
                    
                    if($get) :
                        foreach($get as $item) :
                            $total_belanja = $this -> app -> get_total_jual($item -> id_jual);
                            $total += $total_belanja;
                            $pelanggan = $this -> db -> get_where('pelanggan', ['id' => $item -> id_plg]) -> row();
                            $pelanggan = $item -> id_plg == 0 ? 'Umum' : (isset($pelanggan -> nama) ? $pelanggan -> nama : '-');
                ?>

                    <tr>
                        <td class="text-center">
                            <button class="btn btn-outline-dark border" onclick="detail_riwayat('<?= $item -> id_jual ?>')">
                                <i class="fa fa-eye"></i>
                            </button>
                        </td>
                        <td class="text-center">
                            <?= tgl(date('d M Y', strtotime($item -> tgl))) ?>
                        </td>
                        <td>
                            <?= $item -> kode ?>
                        </td>
                        <td>
                            <?= $pelanggan ?>
                        </td>
                        <td class="text-end">
                            <?= form_uang($total_belanja) ?>
                        </td>
                    </tr>

                <?php endforeach ?>
                        
                    <tr class="table-light">
                        <th></th>
                        <th></th>
                        <th></th>
                        <th class="text-end text-danger">Total Penjualan</th>
                        <th class="text-end text-danger">
                            <?= form_uang($total) ?>
                        </th>
                    </tr>

                <?php endif ?>


                <?php if(empty($get)) : ?>
                    <tr>
                        <td colspan="5" class="text-center">
                            Belum ada item
                        </td>
                    </tr>
                <?php endif ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>