<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/mod.css') ?>">
    <style>
        body {
            font-size: 16px;
        }
        h3, h6 {
            margin: 0 0 0.6rem;
        }
        h6 {
            font-size: 1rem;
        }
        h3 {
            font-size: calc(1.3rem + .6vw);
        }
        .text-center {
            text-align: center;
        }
        .text-end {
            text-align: right;
        }
        .mb-4 {
            margin-bottom: 1.5rem!important;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Penjualan</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        
        <?php if($input['start_date'] == date('Y-m-d')) : ?>
            Hari ini
        <?php elseif($input['start_date'] == $input['end_date']) : ?>
            Tanggal <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>
        <?php else: ?>
            Periode <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>  ~ <?= tgl(date('d F Y', strtotime($input['end_date']))) ?>
        <?php endif ?>
    </div>
    
    <table>
        <thead class="table-light">
            <th class="text-center w-px-150">Tanggal</th>
            <th class="text-center w-px-150 ">Nota</th>
            <th class="text-center">Pelanggan</th>
            <th class="w-px-120 text-center">Total Belanja</th>
        </thead>
        <tbody>
            <?php
                $toko   = $this -> session -> mart_toko;
                $admin  = $this -> session -> mart_id;
                $level  = $this -> session -> mart_level;
                $this -> db -> from('penjualan_data data');
                $this -> db -> join('penjualan_detail detail', 'data.id = detail.id_jual');
                if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                    $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                    $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                }
                if($level != 'owner') {
                    $this -> db -> where('data.id_admin', $admin);
                }
                $this -> db -> where('data.id_toko', $toko);
                $this -> db -> where('qty > ', 0);
                $this -> db -> order_by('data.id', 'DESC');
                $this -> db -> group_by('detail.id_jual');
                $get = $this -> db -> get() -> result();
                $total = 0;
                
                if($get) :
                    foreach($get as $item) :
                        $total_belanja = $this -> app -> get_total_jual($item -> id_jual);
                        $total += $total_belanja;
                        $pelanggan = $this -> db -> get_where('pelanggan', ['id' => $item -> id_plg]) -> row();
                        $pelanggan = $item -> id_plg == 0 ? 'Umum' : (isset($pelanggan -> nama) ? $pelanggan -> nama : '-');
            ?>

                <tr>
                    <td class="text-center">
                        <?= tgl(date('d M Y', strtotime($item -> tgl))) ?>
                    </td>
                    <td>
                        <?= $item -> kode ?>
                    </td>
                    <td>
                        <?= $pelanggan ?>
                    </td>
                    <td class="text-end">
                        <?= form_uang($total_belanja) ?>
                    </td>
                </tr>

            <?php endforeach ?>
                    
                <tr class="table-light">
                    <th></th>
                    <th></th>
                    <th class="text-end text-danger">Total Penjualan</th>
                    <th class="text-end text-danger"><?= form_uang($total) ?></th>
                </tr>

            <?php endif ?>


            <?php if(empty($get)) : ?>
                <tr>
                    <td colspan="5" class="text-center">
                        Belum ada item
                    </td>
                </tr>
            <?php endif ?>
        </tbody>
    </table>

    <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
    <script>
        if($(window).width() > 768) {
            setTimeout(function () { window.print(); }, 0);
            window.onload = function () { setTimeout(function () { window.close(); }, 0); }
        } else {
            print();
        }
    </script>
</body>
</html>
