<div class="px-3">
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Stok Opname</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        
        <?php if($input['start_date'] == date('Y-m-d')) : ?>
            Hari ini
        <?php elseif($input['start_date'] == $input['end_date']) : ?>
            Tanggal <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>
        <?php else: ?>
            Periode <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>  ~ <?= tgl(date('d F Y', strtotime($input['end_date']))) ?>
        <?php endif ?>
    </div>
    
    <div class="table-responsive mb-4">
        <table class="table table-bordered">
            <thead class="table-light">
                <th class="text-center w-px-80"></th>
                <th class="text-center w-px-150">Tanggal</th>
                <th class="w-px-150 text-center">Kode</th>
                <th class="text-center">Petugas</th>
                <th class="w-px-100 text-center">Stok Valid</th>
                <th class="w-px-120 text-center">Stok Invalid</th>
            </thead>
            <tbody>
                <?php
                    $limit      = $input['limit'];
                    $active     = $input['active'];
                    $toko = $this -> session -> mart_toko;
    
                    $this -> db -> from('opname_data');
                    if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                        $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                        $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                    }
                    $this -> db -> where('id_toko', $toko);                    
                    $total_data = $this -> db -> get() -> num_rows();
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                        'func'       => 'load_data'
                    ];
    
                    $this -> db -> from('opname_data');
                    if(!empty($input['start_date']) AND !empty($input['end_date'])) {
                        $this -> db -> where('DATE(tgl) >=', $input['start_date']);
                        $this -> db -> where('DATE(tgl) <=', $input['end_date']);
                    }
                    $this -> db -> where('id_toko', $toko);
                    $this -> db -> order_by('id', 'DESC');
                    $this -> db -> limit($limit, $offset);
                    $get        = $this -> db -> get() -> result();
                    
                    if($get) :
                        foreach($get as $item) :
                            $admin        = $this -> db -> get_where('admin', ['id' => $item -> id_admin]) -> row();
                            $stok_valid   = $this -> app -> get_stok_valid($item -> id);
                            $stok_invalid = $this -> app -> get_stok_invalid($item -> id);
                            
                ?>

                    <tr>
                        <td class="text-center">
                            <button class="btn btn-outline-dark border" onclick="detail_riwayat('<?= $item -> id ?>')">
                                <i class="fa fa-eye"></i>
                            </button>
                        </td>
                        <td class="text-center">
                            <?= tgl(date('d M Y', strtotime($item -> tgl))) ?>
                        </td>
                        <td class="text-center">
                            <?= $item -> kode ?>
                        </td>

                        <td>
                            <?= $admin -> nama ?>
                        </td>

                        <td class="text-center">
                            <?= $stok_valid ?>
                        </td>

                        <td class="text-center">
                            <?= $stok_invalid ?>
                        </td>
                    </tr>

                <?php endforeach ?>
                <?php endif ?>


                <?php if(empty($get)) : ?>
                    <tr>
                        <td colspan="6" class="text-center">
                            Belum ada item
                        </td>
                    </tr>
                <?php endif ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>