<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/mod.css') ?>">
    <style>
        body {
            font-size: 16px;
        }
        h3, h6 {
            margin: 0 0 0.6rem;
        }
        h6 {
            font-size: 1rem;
        }
        h3 {
            font-size: calc(1.3rem + .6vw);
        }
        .text-center {
            text-align: center;
        }
        .text-start {
            text-align: left;
        }
        .text-end {
            text-align: right;
        }
        .mb-4 {
            margin-bottom: 1.5rem!important;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div class="text-center mb-4">
        <h6 class="mb-1">
            <strong>Laporan Keuangan</strong>
        </h6>
        <h3 class="mb-1">
            <strong>
                <?= $this -> app -> get_toko($this -> session -> mart_toko, 'nama') ?>
            </strong>
        </h3>
        <small>
            <?= $this -> app -> get_toko($this -> session -> mart_toko, 'alamat') ?>
        </small>
        <hr>
        
        <?php if($input['start_date'] == date('Y-m-d')) : ?>
            Hari ini
        <?php elseif($input['start_date'] == $input['end_date']) : ?>
            Tanggal <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>
        <?php else: ?>
            Periode <br> <?= tgl(date('d F Y', strtotime($input['start_date']))) ?>  ~ <?= tgl(date('d F Y', strtotime($input['end_date']))) ?>
        <?php endif ?>
    </div>
    
    <?php 
        $toko  = $this -> session -> mart_toko;
               
        $this -> db -> select('detail.id_beli, qty, harga_beli');
        $this -> db -> from('pembelian_data data');
        $this -> db -> join('pembelian_detail detail', 'data.id = detail.id_beli');
        $this -> db -> where('data.id_toko', $toko);

        if(!empty($input['start_date']) AND !empty($input['end_date'])) {
            $this -> db -> where('DATE(data.tgl) >=', $input['start_date']);
            $this -> db -> where('DATE(data.tgl) <=', $input['end_date']);
        }

        $get_beli   = $this -> db -> get() -> result();
        $jml_beli   = 0;
        $total_beli = 0;

        foreach($get_beli as $beli) {
            $jml_beli += $beli -> qty;
            $total_beli += $beli -> qty * $beli -> harga_beli;
        }

        $this -> db -> select('detail.id_jual, qty, harga_jual, id_brg, id_satuan');
        $this -> db -> from('penjualan_data data');
        $this -> db -> join('penjualan_detail detail', 'data.id = detail.id_jual');
        $this -> db -> where('data.id_toko', $toko);

        if(!empty($input['start_date']) AND !empty($input['end_date'])) {
            $this -> db -> where('DATE(data.tgl) >=', $input['start_date']);
            $this -> db -> where('DATE(data.tgl) <=', $input['end_date']);
        }

        $get_jual   = $this -> db -> get() -> result();
        $jml_jual   = 0;
        $total_jual = 0;
        $total_profit = 0;

        foreach($get_jual as $jual) {
            $barang = $this -> db -> get_where('barang', ['id_toko' => $toko, 'id' => $jual -> id_brg]) -> row();

            $jml_jual   += $jual -> qty;
            $total_jual += $jual -> qty * $jual -> harga_jual;
            
            if($barang) {
                $where['id_brg']    = $jual -> id_brg;
                $where['id_toko']   = $this -> session -> mart_id;
                $where['id_satuan'] = $jual -> id_satuan;

                $cek_satuan = $this -> db -> get_where('barang_satuan', $where) -> last_row();
                $cek_trx    = $this -> db -> get_where('pembelian_detail', $where) -> last_row();

                $harga_beli    = $cek_trx ? $cek_trx -> harga_beli : $cek_satuan -> harga_beli;
                $total_profit += ($cek_satuan -> harga_jual - $harga_beli) * $jual -> qty;
            }
        }

        $pendapatan = ($total_jual) - ($total_beli);
    ?>
    
    <div class="table-responsive mb-4">
        <table class="table table-bordered">
            <tbody>
                
                <tr>
                    <td colspan="3">Rincian Pembelian Barang</td>
                </tr>
                <tr>
                    <td class="w-px-200">Jumlah</td>
                    <td><?= $jml_beli ?> Item</td>
                </tr>
                <tr>
                    <td>Total</td>
                    <td><?= form_uang($total_beli) ?></td>
                </tr>
                <tr>
                    <td colspan="3">Rincian Penjualan Barang</td>
                </tr>
                <tr>
                    <td class="w-px-150">Jumlah</td>
                    <td><?= $jml_jual ?> Item</td>
                </tr>
                <tr>
                    <td>Total</td>
                    <td><?= form_uang($total_jual) ?></td>
                </tr>
                <tr>
                    <th class="text-start">Total Pembelian</th>
                    <th class="text-start"><?= form_uang($total_beli) ?></th>
                </tr>
                <tr>
                    <th class="text-start">Total Penjualan</th>
                    <th class="text-start"><?= form_uang($total_jual) ?></th>
                </tr>
                <tr>
                    <th class="text-start">Total Pendapatan</th>
                    <th class="text-start"><?= form_uang($pendapatan) ?></th>
                </tr>
                <tr>
                    <th class="text-start">Total Profit</th>
                    <th class="text-start"><?= form_uang($total_profit) ?></th>
                </tr>
            </tbody>
        </table>
    </div>
    
    <script src="<?= base_url() ?>assets/vendor/jQuery/jquery.min.js"></script>
    <script>
       if($(window).width() > 768) {
            setTimeout(function () { window.print(); }, 0);
            window.onload = function () { setTimeout(function () { window.close(); }, 0); }
        } else {
            print();
        }
    </script>
</body>
</html>
