<div class="page_title d-flex justify-content-between align-items-start">
    <div class="flex-grow-1">
        <h2>Karyawan</h2>
        <p>Data karyawan</p>
    </div>
</div>

<?php if($this -> session -> mart_demo == 0) : ?>
    
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-none" >
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="card-title">
                            <h5>Data</h5>
                            <small class="text-muted">
                            List karyawan
                            </small>
                        </div>
                        <button class="btn btn-primary px-3" id="tambah">
                            <i class="fa fa-plus me-1"></i> 
                            Baru
                        </button>
                    </div>
                    <div class="row justify-content-between mt-3">
                        <div class="col-sm-2 mb-2">
                            <select class="form-select w-px-80 select2-nosrc" id="limiter">
                                <option>10</option>
                                <option selected>25</option>
                                <option>50</option>
                                <option>100</option>
                            </select>
                        </div>
                        <div class="col-sm-4 mb-2">
                            <div class="input-group">
                                <input type="search" id="pencarian"
                                        placeholder="Cari karyawan" 
                                        class="form-control"
                                >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0" id="data_brg">
                    
                </div>
            </div>
        </div>
    </div>

    <form method="POST" class="modal fade" id="modal">
        <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <div>
                        <h5 class="modal-header-title mb-0">
                            <strong>
                                karyawan
                            </strong>
                        </h5>
                        <small>
                            Tambah karyawan
                        </small>
                    </div>
                    <a href="javascript:void(0)" 
                        class="btn-close" 
                        data-bs-dismiss="modal"
                    ></a>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="id" value="0">
                            
                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Nama karyawan </strong>
                            <small class="text-muted">
                                Masukan nama karyawan
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"required 
                                class="form-control" 
                                name="nama" 
                            >
                        </div>
                    </div>
                
                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Email</strong>
                            <small class="text-muted">
                                Masukan email karyawan
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"required 
                                class="form-control" 
                                name="email" 
                            >
                        </div>
                    </div>
                
                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Password</strong>
                            <small class="text-muted">
                                Masukan password login karyawan
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <input type="password"required 
                                class="form-control" 
                                name="password" 
                            >
                        </div>
                    </div>
                
                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Posisi </strong>
                            <small class="text-muted">
                                Pilih posisi karyawan
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <select name="level" class="form-select select2-nosrc">
                                <option value="admin">Admin</option>
                                <option value="kasir">Kasir</option>
                            </select>
                        </div>
                    </div>      

                    <div class="row mb-3">
                        <div class="col-sm-4 mb-2">
                            <strong class="d-block">Cabang / Penempatan </strong>
                            <small class="text-muted">
                                Pilih penempatan karyawan
                            </small>
                        </div>
                        <div class="col-sm-8">
                            <select name="id_toko" class="form-select select2-nosrc">
                                <?php  
                                    $get = $this -> db -> get('toko') -> result();
                                    foreach($get as $item) {
                                        echo '
                                            <option value="'.$item -> id.'">
                                                '.$item -> nama.'
                                            </option>
                                        ';
                                    }
                                ?>
                            </select>
                        </div>
                    </div>            
                </div>
                
                <div class="modal-footer border-0">
                    <button class="btn btn-primary px-4">
                        Simpan
                    </button>
                    <a href="javascript:void(0)" 
                    class="btn btn-light" 
                    data-bs-dismiss="modal"
                    >
                        Batal
                    </a>
                </div>
            </div>
        </div>
    </form>

    <script>
        function load_data(active) {
            $.post({
                url: base_url + 'proses/load_karyawan',
                dataType: 'html',
                data: {
                    active: active,
                    cari: $('#pencarian').val(),
                    limit: $('#limiter').val(),
                },
                success: data => {
                    $('#data_brg').html(data);
                }
            })
        }

        function edit(id) {
            $('[name="password"]').attr('required',false);

            $.post({
                url: base_url + 'proses/get_karyawan',
                data: {id: id},
                dataType: 'json',
                success: json => {
                    $('#modal').modal('show');
                    $('#modal .modal-header small').text('Edit karyawan');
                    $('[name="id"]').val(json.id);
                    $('[name="nama"]').val(json.nama);
                    $('[name="email"]').val(json.email);
                    $('[name="level"]').val(json.level);
                    $('[name="id_toko"]').val(json.id_toko);
                }
            })
        }

        function hps(id, nama) {
            swal_hps_item.fire().then(res => {
                if(res.isConfirmed) {
                    $.post({
                        url: base_url + 'proses/hps_karyawan',
                        data: {
                            id:id,
                            nama:nama
                        },
                        dataType: 'json',
                        success: json => {
                            if(json.success == 1) {
                                load_data(1);
                            }
                        }
                    })
                }
            })
        }

        $(function() {
            load_data(1);
        });
        
        $(document).on('click', '#tambah', function() {
            $('#modal').trigger('reset').modal('show');
            $('#modal .modal-header small').text('Tambah karyawan');
            $('[name="id"]').val(0);
            $('[name="password"]').attr('required',true);

        });

        $(document).on('change', '#pencarian, #limiter', function() {
            load_data(1);
        });

        $(document).on('submit', 'form', function(e) {
            e.preventDefault();
            let form = $(this);

            swal_simpan.fire().then(res => {
                if(res.isConfirmed) {
                    $.post({
                        url: base_url + 'proses/simpan_karyawan',
                        data: form.serialize(),
                        dataType: 'json',
                        success: json => {
                            if(json.success == 1) {
                                load_data(1);
                                $('#modal').modal('hide').trigger('reset');
                                
                                toast({
                                    icon: 'success',
                                    title: json.msg
                                })
                            } else {
                                toast({
                                    icon: 'error',
                                    title: json.msg
                                })
                            }
                        }
                    })
                }
            });
        });

        
    </script>

<?php else: ?>
    <div class="msg warning">
        <i class="fa fa-info-circle me-1"></i>
        Halaman ini tidak tersedia untuk akun demo
    </div>
<?php endif ?>