<div class="page_title">
	<h2>Dashboard</h2>
	<p>Halaman Utama</p>
</div>

<?php if($this  -> session -> mart_demo == 1) : ?>
	<div class="msg warning mb-3">
		<strong class="d-block mb-1"><i class="fa fa-info-circle me-1"></i> Akun Demo</strong>
		<span>Saat ini anda login menggunakan akun demo. Ada beberapa fitur dibatasi penggunaannya. </span>
	</div>
<?php endif ?>

<div class="row mb-3">
	<?php if($this  -> session -> mart_level == 'owner') : ?>
		<div class="col-md-3">
			<a href="<?= site_url('laporan/keuangan') ?>" class="card card-success with-icon">
				<div class="card-body">
					<p class="mb-1">Pemasukan Hari Ini</p>
					<h4><?= form_uang($total_pemasukan) ?></h4>
					<small class="mb-0">Rupiah</small>
					<div class="card-icon d-flex">
						<i class="fa fa-wallet"></i>
					</div>
				</div>
			</a>
		</div>
	<?php endif ?>

	<?php if($this  -> session -> mart_level != 'admin') : ?>
		<div class="col-md-3">
			<a href="<?= site_url('riwayat/penjualan') ?>" class="card card-warning with-icon">
				<div class="card-body">
					<p class="mb-1">Total Penjualan Hari Ini</p>
					<h4><?= $total_jual ?></h4>
					<small class="mb-0">Barang</small>
					<div class="card-icon d-flex">
						<i class="fa fa-shopping-bag"></i>
					</div>
				</div>
			</a>
		</div>
	<?php endif ?>

	<?php if($this  -> session -> mart_level != 'kasir') : ?>
		<div class="col-md-3">
			<a href="<?= site_url('barang/data') ?>" class="card card-danger with-icon">
				<div class="card-body">
					<p class="mb-1">Total Barang</p>
					<h4><?= $total_brg ?></h4>
					<small class="mb-0">Barang</small>
					<div class="card-icon d-flex">
						<i class="fa fa-box-open"></i>
					</div>
				</div>
			</a>
		</div>
		
		<div class="col-md-3">
			<a href="<?= site_url('riwayat/pembelian') ?>" class="card card-primary with-icon">
				<div class="card-body">
					<p class="mb-1">Total Masuk Hari Ini</p>
					<h4><?= $total_masuk ?></h4>
					<small class="mb-0">Barang</small>
					<div class="card-icon d-flex">
						<i class="fa fa-arrow-up"></i>
					</div>
				</div>
			</a>
		</div>      
	<?php endif ?>
</div>

<div class="row">
	<div class="col-sm-12">
		<div class="card shadow-none mb-3">
			<div class="card-header">
				<div class="card-title d-flex justify-content-between align-items-start">
					<div class="flex-grow-1">
						<h5>Riwayat</h5>
						<small>7 Riwayat Transaksi Terakhir</small>
						<input type="hidden" value="" id="filter_tr">
					</div>
					<?php if($this -> session -> mart_level == 'owner') : ?>
						<div class="dropdown">
							<button class="fa fa-ellipsis-v card-menu" data-bs-toggle="dropdown"></button>
							<ul class="dropdown-menu dropdown-menu-end py-0">
								<li><h6 class="dropdown-header">Filter</h6></li>
								<li>
									<button class="dropdown-item py-2 text-primary btn_filter_tr" data-jenis="">
										<i class="fa fa-list me-2"></i>
										Semua
									</button>
									<button class="dropdown-item py-2 text-success btn_filter_tr" data-jenis="1">
										<i class="fa fa-shopping-basket me-2"></i>
										Penjualan
									</button>
									<button class="dropdown-item py-2 text-danger btn_filter_tr" data-jenis="2">
										<i class="fa fa-truck-ramp-box me-2"></i>
										Pembelian
									</button>
								</li>
							</ul>
						</div>
					<?php endif ?>
				</div>
			</div>
			<div class="card-body" id="riwayat_tr">
				
			</div>
		</div>
	</div>
</div>

<?php if($this -> session -> mart_level != 'admin') : ?>
	<div class="row">
		<div class="col-sm-12">
			<div class="card shadow-none mb-3">
				<div class="card-header">
					<div class="card-title d-flex justify-content-between align-items-start">
						<div class="flex-grow-1">
							<h5>Barang</h5>
							<small>7 barang terlaris bulan ini</small>
						</div>
					</div>
				</div>
				<div class="card-body" id="terlaris">
					
				</div>
			</div>
		</div>
	</div>
<?php endif ?>

<!-- <div class="row" id="chart_home">
	<div class="col-sm-12">
		<div class="card shadow-none">
			<div class="card-header">
				<div class="card-title d-flex justify-content-between align-items-start">
					<div class="flex-grow-1">
						<h5>Statistik</h5>
						<small>Transaksi minggu ini</small>
					</div>
					<div class="chart-date-info text-end">
						<h5 class="text-danger tahun">
							2023
						</h5>
						<small class="text-muted periode">20 Agu ~ 27 Agu</small>
					</div>
				</div>
			</div>
			<div class="card-body">
				<canvas id="chartjs" class="h-vh-60"></canvas>
			</div>
		</div>
	</div>
</div> -->

<script>
	$(function() {
		load_tr();
		load_terlaris()
	})

	function load_tr() {
		$.post({
			url: base_url + 'proses/home_transaksi',
			data: {filter: $('#filter_tr').val()},
			success: data => {
				$('#riwayat_tr').html(data);
			}
		})
	}

	function load_terlaris() {
		$.post({
			url: base_url + 'proses/home_terlaris',
			success: data => {
				$('#terlaris').html(data);
			}
		})
	}

	$(document).on('click', '.btn_filter_tr', function() {
		let jenis = $(this).data('jenis');

		$('#filter_tr').val(jenis);
		load_tr();
	})
</script>

<!-- <script src="assets/vendor/chartjs/chart.js"></script> -->
<!-- <script>
	$.post({
		url: base_url + 'home/set_grafik',
		dataType: 'json',
		success: json => {
			const ctx = document.getElementById('chartjs');

			$('.tahun').text(json.tahun);
			$('.periode').text(json.periode);
		
			new Chart(ctx, {
				type: 'line',
				data: {
					labels: json.hari,
					datasets: [
						{
							label: 'Penjualan',
							data: json.penjualan,
							borderWidth: 3, 
							tension: 0.4
						},
						{
							label: 'Pembelian',
							data: json.pembelian,
							borderWidth: 3, 
							tension: 0.4
						}
					]
				},
				options: {
					maintainAspectRatio: false,
					scales: {
						y: {
							beginAtZero: true,
							ticks: {
								maxTicksLimit: 7,
								padding: 5,                        
							},
							grid: {
								color: "rgba(0,0,0,0.2)",
							},
							border: {
								dash: [2, 4]
							}
						},
						x: {
							grid: {
								display: false,
							}
						}
					},
					plugins: {
						legend: {
							labels: {
								usePointStyle: true,
								pointStyle: 'circle'
							}
						},
						tooltip: {
							backgroundColor: "rgb(255,255,255)",
							bodyColor: "#858796",
							titleMarginBottom: 10,
							titleColor: '#6e707e',
							titleSize: 14,
							borderColor: '#dddfeb',
							borderWidth: 1,
							padding: 15,
							intersect: false,
							mode: 'index',
							caretPadding: 15,   
						}
					}
				}
			});
		}
	})
</script> -->