<div class="page_title d-flex justify-content-between align-items-start flex-wrap">
    <div class="flex-grow-1">
        <h2>Barang</h2>
        <p>Tambah Stok Opname</p>
    </div>
    <div>
        <button class="btn bg-white" data-bs-toggle="modal" data-bs-target="#modal_shortcut">
            <i class="fa fa-keyboard me-1"></i>
            Shortcut
        </button>
    </div>
</div>

<div class="card mb-2">
    <div class="card-header">
        <div class="card-title">
            <h5>
                <i class="fa fa-bullhorn me-1"></i>
                Penting
            </h5>
        </div>
    </div>
    <div class="card-body">
        <li> Pastikan semua data sudah benar sebelum disimpan. </li>
        <li> Data opname yang sudah disimpan tidak dapat diubah kembali. </li>
        <li> Jika stok fisik kosong, maka jumlahnya akan sama dengan jumlah stok sistem. </li>
    </div>
</div>

<div class="card mb-2">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm table-borderless mb-0 bg-transparent">
                <tbody>
                    <tr>
                        <th>
                            Petugas
                        </th>
                        <th> : </th>
                        <th> 
                            <?= $this -> app -> get_admin('nama') ?>                                    
                        </th>
                    </tr>
                    <tr>
                        <th class="w-px-120">
                            Tanggal
                        </th>
                        <th class="w-px-20"> : </th>
                        <th> 
                            <input type="date" class="form-control w-px-200" id="tgl_opname" value="<?= date('Y-m-d') ?>">
                        </th>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header pt-3">
        <div class="header-title d-flex justify-content-between align-items-start flex-wrap">
            <div>
                <button class="btn border dropdown-toggle px-4" data-bs-toggle="dropdown">
                    <i class="fa fa-plus me-1"></i>
                    Barang
                </button>
    
                <ul class="dropdown-menu">
                <li><h6 class="dropdown-header">Aksi</h6></li>
                    <li>
                        <button class="dropdown-item text-primary py-2" onclick="data_brg(1)">
                            <i class="fa fa-search me-1"></i>
                            Cari Barang
                        </button>
                    </li>
                    <li>
                        <button class="dropdown-item text-warning py-2" onclick="open_scanner('kamera')">
                            <i class="fa fa-camera me-1"></i>
                            Scan dengan Kamera
                        </button>
                    </li>
                    <li>
                        <button class="dropdown-item text-danger py-2" onclick="open_scanner('scanner')">
                            <i class="fa fa-qrcode me-1"></i>
                            Scan dengan Scanner
                        </button>
                    </li>
                </ul>
            </div>
            <div>
                <input type="text" class="form-control" id="add_by_code" placeholder="Kode Barang">
            </div>
        </div>
    </div>
    
    <div class="card-body" id="list">
        
    </div>
</div>

<div class="modal fade" tabindex="-1" id="modal_barang">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content border-0">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        List Barang
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body p-0">
                <div class="px-3 pt-3">
                    <div class="row justify-content-between mb-2">
                        <div class="col-sm-2 mb-2">
                            <select class="form-select w-px-80 select2-nosrc" id="limiter">
                                <option>10</option>
                                <option selected>25</option>
                                <option>50</option>
                                <option>100</option>
                            </select>
                        </div>
                        <div class="col-sm-4 mb-2">
                            <div class="input-group">
                                <input type="search" id="pencarian"
                                        placeholder="Cari Barang" 
                                        class="form-control"
                                >
                            </div>
                        </div>
                    </div>
                </div>

                <div id="list_data_brg">
                    
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_scanner">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan scanner
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body text-center">
                <div class="border p-4 bg-light rounded">
                    <img src="<?= base_url('assets/img/scanner.png') ?>">
                    <div class="mt-3" style="position: relative;overflow:hidden">
                        Arahkan scanner ke barcode
                    </div>
                </div>
                <div class="form-check text-start mt-3">
                    <input type="text" id="inp_scanner">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_modal">
                    <label class="form-check-label" for="autoclose_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_shortcut">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Shortcut
                        </strong>
                    </h5>
                    <small>
                        
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body bg-light">
                <ul class="list-group">
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Menampilkan list barang yang tersedia
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F1
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Scan kode barang dengan kamera
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F2
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Scan kode barang dengan scanner
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F3
                            </h5>
                        </div>
                    </li>
                    <li class="list-group-item bg-white">
                        <div class="float-start pe-3">
                            <small class="d-block text-muted">
                                Aksi
                            </small>
                            <span>
                                Input kode barang
                            </span>

                        </div>
                        <div class="float-end">
                            <h5 class="fs-1" style="opacity: 0.3">
                                F4
                            </h5>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {
        load_data();
    })

    function load_data() {
        $.post({
            url: base_url + 'proses/load_tambah_list',
            success: data => {
                $('#list').html(data);
                tooltip();
                select2();
            }
        })
    }

    function add_item(kode, tipe) {
        $.post({
            url: base_url + 'proses/add_item_opname',
            data: {kode:kode},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    load_data();

                    if(json.msg == 'tersedia') {
                        toast({
                            icon: 'info',
                            title: 'Item sudah ditambahkan'
                        })

                    } else {
                        toast({
                            icon: 'success',
                            title: json.msg
                        })

                    }

                    if(tipe == 'input') {
                        $('#add_by_code').val('');
                    }
                } else {
                    toast({
                        icon: 'error',
                        title: json.msg
                    })
                }
            }
        })
    }

    function data_brg(page) {
        $.post({
            url: base_url + 'proses/load_list_brg',
            data: {
                cari: $('#pencarian').val(),
                limit: $(document).find('#limiter').val(),
                active: page,
            },
            success: data => {
                $('#modal_barang').modal('show')
                                  .find('#list_data_brg')
                                  .html(data)
                ;

                select2();
            }
        });
    } 

    function cek_data(code, mode) {
        $.post({
            url: base_url + 'proses/cek_data',
            data: {code:code},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    $('#add_by_code').val(code).change().val('');

                    if($('.autoclose').is(':checked')) {
                        $('.modal').modal('hide');
                    }

                } else if(json.success == 0) {
                    toast({
                        icon: 'error',
                        title: json.msg
                    });

                }

                if(mode == 'scanner') {
                    $('#inp_scanner').val('');
                }
            }
        })
    }

    function open_scanner(scanner) {
        if(scanner == 'kamera') {
            $('#modal_scan_kamera').modal('show');
        } else {
            $('#modal_scanner').modal('show')
        }
    }

    $(document).on('click', '.hps_item', function( ) {
        let elm = $(this);
        let id  = elm.data('id');

        swal_hps_item.fire().then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_item_opname',
                    data: {id:id},
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data();

                            elm.closest('tr').remove();
                        }
                    }
                })
            }
        })
    })

    $(document).on('click', '.select_item', function() {
        let kode = $(this).data('kode');

        add_item(kode);
    })

    $(document).on('change', '#add_by_code', function() {
        add_item(this.value, 'input');
    })

    $(document).on('change', '.stok_fisik', function() {
        let val = $(this).val();
        let id  = $(this).data('id');

        $('input:not(.stok_sistem), select').attr('disabled', true);
        
        $.post({
            url: base_url + 'proses/update_stok_fisik',
            data: {
                id:id,
                stok: val
            },
            dataType: 'json',
            success: json => {
                $('input:not(.stok_sistem), select').attr('disabled', false);
                if(json.success == 1) {
                    load_data();
                }
            }
        })
    })

    $(document).on('change', '.id_satuan', function() {
        let val = $(this).val();
        let id  = $(this).data('id');

        $('input:not(.stok_sistem), select').attr('disabled', true);
        
        $.post({
            url: base_url + 'proses/update_satuan_opname',
            data: {
                id:id,
                satuan: val
            },
            dataType: 'json',
            success: json => {
                $('input:not(.stok_sistem), select').attr('disabled', false);
                if(json.success == 1) {
                    load_data();
                }
            }
        })
    })

    $(document).on('change', '.note', function() {
        let val = $(this).val();
        let id  = $(this).data('id');

        $('input:not(.stok_sistem), select').attr('disabled', true);
        
        $.post({
            url: base_url + 'proses/update_ket_opname',
            data: {
                id:id,
                ket: val
            },
            dataType: 'json',
            success: json => {
                $('input:not(.stok_sistem), select').attr('disabled', false);
                if(json.success == 1) {
                    load_data();
                }
            }
        })
    })

    $(document).on('change', '#inp_scanner', function() {
        add_item(this.value, 'scanner')
    });

    $(document).on('shown.bs.modal', '#modal_scanner', function() {
        $(document).on('keydown', function(e) {
            if(e.which == 13) {
                $('#inp_scanner').focus();
            }
        })
    })

    $(document).on('click', '.simpan_opname', function() {
        let tgl = $('#tgl_opname').val();
        let btn = $(this);

        btn.addClass('disabled').text('Menyimpan');
        
        swal_simpan.fire({
            text: 'Pastikan data stok opname sudah benar sebelum disimpan. Setelah disimpan data tidak dapat diubah kembali'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_opname',
                    data: {
                        tgl: tgl
                    },
                    dataType: 'json',
                    success: json => {
                        btn.removeClass('disabled').text('Simpan');
                        if(json.success == 1) {
                            load_data();

                            toast({
                                icon: 'success',
                                title: json.msg
                            })

                            setTimeout(() => {
                                redirect('barang/opname');
                            }, 1200);
                        }
                    }
                })
            } else {
                btn.removeClass('disabled').text('Simpan');
            }
        })
    })

    $(document).on('keydown', function(e) {
        switch (e.which) {
            // list barang
            case 112:
                e.preventDefault()
                data_brg(1);       
            break;

            // scan dengan kamera
            case 113:
                e.preventDefault()
                open_scanner('kamera');       
            break;

            // scan dengan scanner
            case 114:
                e.preventDefault()
                open_scanner('scanner');       
            break;

            // Fokus input kode barang 
            case 115:
                e.preventDefault()
                $('#add_by_code').focus();       
            break;
        }
    })
</script>


<div class="modal fade" id="modal_scan_kamera">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan kamera
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                <div id="qr-reader" class="w-100 bg-light"></div>
                <div class="form-check text-start mt-3">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_cam_modal">
                    <label class="form-check-label" for="autoclose_cam_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url('assets/vendor/scanner/html5-qrcode.min.js') ?>"></script>
<script>
    var last, count = 0;
    var html5QrcodeScanner = new Html5QrcodeScanner(
        "qr-reader", { fps: 10, qrbox: 250 });

    function success_scan(text, result) {
        if(text !== last) {
            ++count;
            last = text;
            add_item(text, 'scanner');
        }
    }

    $(document).on('shown.bs.modal', '#modal_scan_kamera', function() {
        html5QrcodeScanner.render(success_scan);
    })

    $(document).on('hidden.bs.modal', '#modal_scan_kamera', function() {
        html5QrcodeScanner.clear();
    })
</script>