<div class="page_title d-flex justify-content-between align-items-start">
    <div class="flex-grow-1">
        <h2>Barang</h2>
        <p>Data Opname</p>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card shadow-none" >
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-start">
                    <div class="card-title">
                        <h5>Data</h5>
                        <small class="text-muted">
                           List opname
                        </small>
                    </div>
                    <button class="btn btn-primary px-3" onclick="redirect('barang/opname/tambah')">
                        <i class="fa fa-plus me-1"></i> 
                        Baru
                    </button>
                </div>
                <div class="row justify-content-between mt-3">
                    <div class="col-sm-2 mb-2">
                        <select class="form-select w-px-80 select2-nosrc" id="limiter">
                            <option>10</option>
                            <option selected>25</option>
                            <option>50</option>
                            <option>100</option>
                        </select>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <div class="input-group">
                            <input type="search" id="pencarian"
                                    placeholder="Cari" 
                                    class="form-control"
                            >
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body p-0" id="data_brg">
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_detail">
    <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Opname
                        </strong>
                    </h5>
                    <small>
                        Detail stok opname
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                
            </div>
        </div>
    </div>
</div>

<script>
    function load_data(active) {
        $.post({
            url: base_url + 'proses/load_data_opname',
            dataType: 'html',
            data: {
                active: active,
                cari: $('#pencarian').val(),
                limit: $('#limiter').val(),
            },
            success: data => {
                $('#data_brg').html(data);
            }
        })
    }

    function detail(id) {
        $.post({
            url: base_url + 'proses/load_detail_opname',
            data: {id:id},
            success: data => {
                $('#modal_detail').modal('show').find('.modal-body').html(data);
            }
        })
    }
  
    $(function() {
        load_data(1);
    });
   
    $(document).on('change', '#pencarian, #limiter', function() {
        load_data(1);
    });
    
</script>