<?php 
    $barang     = $this -> app -> get_barang_detail($id);
    $checked    = $barang -> is_multi_satuan == 1 ? 'checked' : null;
    $is_multi   = $barang -> is_multi_satuan == 0 ? 'd-none' : null;
    $data_multi = $this -> app -> get_barang_satuan($id, 2);
   
?>
<div class="modal-header border-0">
    <div>
        <h5 class="modal-header-title mb-0">
            <strong>
                Barang
            </strong>
        </h5>
        <small>
            Multi Satuan
        </small>
    </div>
    <a href="javascript:void(0)" 
        class="btn-close" 
        data-bs-dismiss="modal"
    ></a>
</div>

<?php if($barang -> id_satuan) : ?>
    <div class="modal-body">
        <input type="hidden" name="multi_satuan_brg" value="<?= $id ?>">
        <div class="alert alert-light">
            <div class="d-flex justify-content-between align-items-start">
                <p class="mb-1 me-4">
                    <?= $barang -> nama ?>
                </p>
                <div class="form-check form-switch">
                    <input class="form-check-input" 
                            value="0" 
                            type="checkbox" 
                            role="switch" id="is_multi_satuan" 
                            data-id="<?= $id ?>"
                            name="is_multi_satuan" <?= $checked ?>
                    >
                    <label class="form-check-label label-sw" for="is_multi_satuan"></label>
                </div>
            </div>
            <small class="text-muted">
                Kode: <?= $barang -> kode ?>
            </small>
        </div>
        
        <button class="btn btn-light btn-sm border my-3 btn_add_multi <?= $is_multi ?>">
            <i class="fa fa-plus me-1"></i>
            Tambah
        </button>
        
        <div class="multi_satuan_data <?= $is_multi ?>">
            <?php if($data_multi) : ?>
                <?php 
                    foreach($data_multi as $multi) :
                        $stok = '';
                        $cek_stok    = $this -> app -> cek_stok_brg($multi -> id);

                        if($cek_stok == 0) {
                            $stok = '
                                <small class="text-danger d-block mt-1">
                                    <i class="fa fa-exclamation-circle me-1"></i>
                                    Stok kosong
                                </small>
                            ';
                        } else {
                            $stok = '
                                <small class="d-block mt-1">
                                    Stok: '. $cek_stok .'
                                </small>
                            ';
                        }
                ?>
                    <div class="row mb-3">
                        <div class="col-sm-4 mt-2">
                            <input type="hidden" name="multi_satuan_id[]" value="<?= $multi -> id ?>">
                            <select name="multi_satuan_name[]" class="form-select" required>
                                <option value="">Pilih Satuan</option>

                                <?php 
                                    $this -> db -> order_by('nama');
                                    $this -> db -> where('id !=', $barang -> id_satuan);
                                    $data_satuan = $this -> db -> get('satuan') -> result();
                                    foreach($data_satuan as $satuan) {
                                        $selected    = $satuan -> id == $multi -> id_satuan ? 'selected' : null;                                  

                                        echo '
                                            <option value="'.$satuan -> id.'" '.$selected.'>
                                                '.$satuan -> nama.'
                                            </option>
                                        ';
                                    }
                                ?>
                            </select>
                            
                        </div>
                        <div class="col-sm-2 mt-2">
                            <div class="input-group">
                                <input type="number" 
                                        class="form-control nochange" 
                                        placeholder="Isi" 
                                        value="<?= $multi -> isi ?>"
                                        name="multi_satuan_stock[]" 
                                        required
                                >
                                <div class="input-group-text">
                                    <?= $barang -> satuan ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mt-2">
                            <div class="input-group">
                                <input type="text" 
                                        class="form-control form_uang" 
                                        placeholder="Harga Jual" 
                                        value="<?= form_uang($multi -> harga_jual) ?>"
                                        name="multi_satuan_price[]" 
                                        required
                                >
                                <input type="text" 
                                        class="form-control form_uang" 
                                        placeholder="Harga Beli" 
                                        value="<?= form_uang($multi -> harga_beli) ?>"
                                        name="multi_satuan_beli[]" 
                                        required
                                >
                                <button class="btn btn-danger btn_hps_multi" data-id="<?= $multi -> id ?>" data-aksi="1">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <?= $stok ?>
                        </div>
                    </div>
                <?php endforeach ?>
            <?php else: ?>
                <div class="row mb-3">
                    <div class="col-sm-4 mb-2">
                        <input type="hidden" name="multi_satuan_id[]" value="0">
                        <select name="multi_satuan_name[]" class="form-select" required>
                            <option value="">Pilih Satuan</option>

                            <?php 
                                $this -> db -> order_by('nama');
                                $this -> db -> where('id !=', $barang -> id_satuan);
                                $data_satuan = $this -> db -> get('satuan') -> result();
                                foreach($data_satuan as $satuan) {
                                    echo '
                                        <option value="'.$satuan -> id.'" >
                                            '.$satuan -> nama.'
                                        </option>
                                    ';
                                }
                            ?>
                        </select>
                    </div>
                    <div class="col-sm-2 mb-2">
                        <div class="input-group">
                            <input type="number" class="form-control nochange" placeholder="Isi" name="multi_satuan_stock[]" required>
                            <div class="input-group-text">
                                <?= $barang -> satuan ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="input-group">
                            <input type="text" class="form-control form_uang" placeholder="Harga Jual" name="multi_satuan_price[]" required>
                            <input type="text" class="form-control form_uang" placeholder="Harga Beli" name="multi_satuan_beli[]" required>
                            <button class="btn btn-danger btn_hps_multi disabled" data-id="0" data-aksi="0">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif ?>
            
        </div>    
    </div>

    <div class="modal-footer btn_multi_aksi <?= $is_multi ?>">
        <button class="btn btn-primary px-4">
            Simpan
        </button>
        <a href="javascript:void(0)" data-bs-dismiss="modal" class="btn">Batal</a>
    </div>

    <div class="multi_satuan_list d-none">
        <div class="row mb-3">
            <div class="col-sm-4 mb-2">
                <input type="hidden" name="multi_satuan_id[]" value="0">
                <select name="multi_satuan_name[]" class="form-select">
                    <option value="">Pilih Satuan</option>

                    <?php 
                        $this -> db -> order_by('nama');
                        $this -> db -> where('id !=', $barang -> id_satuan);
                        $data_satuan = $this -> db -> get('satuan') -> result();
                        foreach($data_satuan as $satuan) {
                            echo '
                                <option value="'.$satuan -> id.'" >
                                    '.$satuan -> nama.'
                                </option>
                            ';
                        }
                    ?>
                </select>
            </div>
            <div class="col-sm-2 mb-2">
                <div class="input-group">
                    <input type="number" class="form-control nochange" placeholder="Isi" name="multi_satuan_stock[]">
                    <div class="input-group-text">
                        <?= $barang -> satuan ?>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 mb-2">
                <div class="input-group">
                    <input type="text" class="form-control form_uang" placeholder="Harga Jual" name="multi_satuan_price[]">
                    <input type="text" class="form-control form_uang" placeholder="Harga Beli" name="multi_satuan_beli[]">
                    <button class="btn btn-danger btn_hps_multi" data-id="0" data-aksi="1">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="modal-body">
        <div class="msg warning mb-0">
            <i class="fa fa-exclamation-circle me-1"></i> 
            Satuan utama belum dipilih
        </div>
    </div>
<?php endif ?>