<div class="px-3">
    <div class="table-responsive mt-3">
        <table class="table table-bordered">
            <thead>
                <tr class="table-light">
                    <th class="w-px-50"></th>
                    <th>Nama Barang</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                    $filterid    = '';
                    $data_filter = [];
                    $today       = time();
                    $cari        = $input['cari'];
                    $limit       = $input['limit'];
                    $active      = $input['active'];
                    $filter      = $input['filter'];
                    $toko        = $this -> session -> mart_toko;

                    if($filter && $filter == 'kadaluarsa') {
                        $getdata = $this -> db -> get_where('barang', ['id_toko' => $toko]) -> result();
                        foreach($getdata as $row) {
                            $kadaluarsa = $row -> tgl_kadaluarsa;

                            if($kadaluarsa) {
                                $kadaluarsa = strtotime($row -> tgl_kadaluarsa);

                                if($today > $kadaluarsa) {
                                    $data_filter[] = $row -> id;
                                }
                            }
                        }

                    } else if($filter && $filter == 'stok_kosong') {
                        $getdata = $this -> db -> get_where(
                            'barang_satuan', 
                            [
                                'id_toko' => $toko, 
                                'stok'    => 0
                            ]
                        ) -> result();

                        foreach($getdata as $row) {
                            $data_filter[] = $row -> id_brg;
                        }
                    }

                    $data_filter = array_unique($data_filter);
			        $data_filter = array_values($data_filter);
                    
                    foreach($data_filter as $f) {
                        $filterid .= $f . ','; 
                    }
                    
                    $filterid  = $filterid ? rtrim($filterid, ',') : -1;

                    if($filter) {
                        $where = "nama LIKE '%$cari%' AND id_toko = '$toko' AND id IN(".$filterid.") OR kode LIKE '%$cari%' AND id_toko = '$toko' AND id IN(".$filterid.")";
                        
                    } else {
                        $where = "nama LIKE '%$cari%' AND id_toko = '$toko' OR kode LIKE '%$cari%' AND id_toko = '$toko'";
                    }
    
                    $this -> db -> where($where);            
                    $total_data = $this -> db -> get('barang') -> num_rows();                    
                    $offset     = $limit * ($active - 1);
                    $max_page   = ceil(($total_data / $limit) + 1);
    
                    $pagination = [
                        'active'     => $active,
                        'max_page'   => $max_page,
                    ];
                    
                    $this -> db -> where($where);
                    $this -> db -> limit($limit, $offset);
                    $this -> db -> order_by('id', 'DESC');
                    $data = $this -> db -> get('barang') -> result();

                    if($data) :
                        foreach($data as $item) :
                            $tool_title = '';
                            $cek_cart   = $this -> app -> cek_brg_keranjang($item -> id);

                            if($this -> app -> jml_stok_kosong($item -> id, 1) > 0) {
                                $tool_title .= '<li> Stok utama kosong </li>';
                            }
                            
                            if($this -> app -> jml_stok_kosong($item -> id, 2) > 0) {
                                $tool_title .= '<li> Stok multi satuan kosong </li>';
                            }
                            
                            if($this -> app -> jml_brg_kadaluarsa($item -> id) > 0) {
                                $tool_title .= '<li> Barang sudah kadaluarsa </li>';
                            }
                            
                            if($cek_cart > 0) {
                                $tool_title .= '<li> Barang masih dikeranjang belanja</li>';
                            }
                            
                            $tooltip = '
                                <i class="fa fa-exclamation-circle ms-1 text-danger" 
                                    title="<ul class=\'m-0 py-0 ps-3 text-start\'>'.$tool_title.'</ul>" 
                                    data-bs-html="true"
                                    data-bs-toggle="tooltip"
                                ></i>
                            ';

                            $item -> stok   = $this -> app -> get_barang_stok($item -> id);
                            $item -> satuan = $this -> app -> get_barang_stok($item -> id, 'satuan');
                            $nama   = empty($tool_title) ? $item -> nama : $item -> nama . $tooltip;

                ?>
                    <tr>
                        <td class="text-center">
                            <button class="fa fa-ellipsis-v btn_detail_item" data-bs-toggle="dropdown"></button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><h6 class="dropdown-header">Aksi</h6></li>
                                <li>
                                    <button class="dropdown-item py-2 text-success" 
                                            onclick="salin('<?= $item -> kode ?>')"
                                    >
                                        <i class="fa fa-copy me-2"></i>
                                        Salin Kode
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item py-2 text-primary"
                                            onclick="modal_barcode('<?= $item -> kode ?>')"
                                    >
                                        <i class="fa fa-qrcode me-2"></i>
                                        Barcode
                                    </button>
                                </li>
                                <?php if($cek_cart == 0) : ?>
                                    <li>
                                        <button class="dropdown-item py-2 text-danger" onclick="multi_satuan('<?= $item -> id ?>', '<?= $item -> satuan ?>')">
                                            <i class="fa fa-boxes me-2"></i>
                                            Multi satuan
                                        </button>
                                    </li>
                                    <li>
                                        <button class="dropdown-item py-2 text-warning" onclick="harga_grosir('<?= $item -> id ?>', '<?= $item -> satuan ?>')">
                                            <i class="fa fa-rupiah-sign me-2"></i>
                                            Harga Grosir
                                        </button>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </td>
                        <td>
                            <span class="pt-2">
                                <?= $nama ?>
                            </span>
                            <div class="text-muted">
                                <small>
                                    Kode: <?= $item -> kode ?>
                                    <?php if($item -> satuan) : ?>
                                        <span class="mx-2"> | </span>
                                        Stok: <?= $item -> stok ?>   
                                    <?php endif ?>                                      
                                </small>
                            </div>
                            <?php if($cek_cart == 0) : ?>
                                <div class="my-2">
                                    <button class="badge text-bg-light border" onclick="edit_brg('<?= $item -> id ?>')">
                                        Ubah
                                    </button>
                                    <button class="badge text-bg-danger" onclick="hps_brg('<?= $item -> id ?>', '<?= $item -> nama ?>')">
                                        Hapus
                                    </button>
                                </div>
                            <?php endif ?>
                        </td>
                    </tr>
                <?php endforeach ?>                                  
                <?php endif ?>   
                
                <?php if(!empty($cari) && count($data) == 0) : ?>
                    <tr>
                        <td colspan="2">
                            <div class="text-center">
                                Data tidak ditemukan
                            </div>
                        </td>
                    </tr>       
                <?php elseif(count($data) == 0) : ?>  
                        <tr>
                            <td colspan="2">
                                <div class="text-center">
                                    Belum ada data
                                </div>
                            </td>
                        </tr>       
                <?php endif ?> 
            </tbody>
        </table>
    </div>
</div>

<?= $this -> app -> pagination($pagination) ?>