<?php 
    $show_msg_filter = isset($_GET['filter']) ? null : 'd-none';
?>
<div class="page_title d-flex justify-content-between align-items-start">
    <div class="flex-grow-1">
        <h2>Barang</h2>
        <p>Data Barang</p>
    </div>

    <div class="dropdown">
        <button class="fa fa-filter card-menu" data-bs-toggle="dropdown"></button>
        <ul class="dropdown-menu dropdown-menu-end w-px-280">
            <li><h6 class="dropdown-header">Filter</h6></li>
            <li>
                <button class="dropdown-item py-2 text-primary" onclick="redirect('barang/data')">
                    <i class="fa fa-boxes me-2"></i>
                    Semua Barang
                </button>
            </li>
            <li>
                <button class="dropdown-item py-2 text-danger" onclick="redirect('barang/data?filter=stok_kosong')">
                    <i class="fa fa-box-open me-2"></i>
                    Stok Kosong
                </button>
            </li>
            <li>
                <button class="dropdown-item py-2 text-warning" onclick="redirect('barang/data?filter=kadaluarsa')">
                    <i class="fa fa-calendar me-2"></i>
                    Barang Kadaluarsa
                </button>
            </li>
        </ul>
    </div>
</div>

<div class="card mb-2 shadow-none">
    <div class="card-body">
        <button class="btn btn-light border btn-sm" id="print_all_barcode" data-bs-toggle="tooltip" title="Cetak barcode semua barcode barang">
            <i class="fa fa-print me-1"></i> 
            Barcode
        </button>                        
        <button class="btn btn-light border btn-sm btn_export_data">
            <i class="fa fa-download me-1"></i> 
            Export
        </button>
        <button class="btn btn-light border btn-sm btn_import_data">
            <i class="fa fa-upload me-1"></i> 
            Import
        </button>        
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card shadow-none">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-start">
                    <div class="card-title">
                        <h5>Data</h5>
                        <small class="text-muted">
                            List Data Barang
                        </small>
                        <input type="hidden" 
                                id="filter_brg_inp" 
                                value="<?= isset($_GET['filter']) ? $_GET['filter'] : null ?>" 
                        >
                    </div>
                    <button class="btn btn-primary px-3" id="tambah">
                        <i class="fa fa-plus me-1"></i> 
                        Baru
                    </button>
                </div>

                <div class="row justify-content-between mt-3">
                    <div class="col-sm-2 mb-2">
                        <select class="form-select w-px-80 select2-nosrc" id="limit_data">
                            <option>10</option>
                            <option selected>25</option>
                            <option>50</option>
                            <option>100</option>
                        </select>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <div class="input-group">
                            <input type="search" id="src_brg"
                                   placeholder="Cari Barang" class="form-control"
                            >
                            <div class="dropdown">
                                <a href="javascript:void(0)" class="btn btn-light border border-radius-end" onclick="open_scanner('scanner')">
                                    <i class="fa fa-qrcode me-1"></i>
                                    Scan
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="msg_filter <?= $show_msg_filter ?>">
                    <div class="msg light border mb-0 mt-3">
                        <?php if(isset($_GET['filter'])) : ?>
                            <span class="me-1">
                                Menampilkan data berdasarkan filter 
                                <?= $_GET['filter'] == 'kadaluarsa' ? 'barang kadaluarsa' : 'stok kosong' ?>
                            </span>
                        <?php else: ?>
                            <span class="me-1">
                                Menampilkan data berdasarkan pencarian
                            </span>
                        <?php endif ?>
                        <a href="<?= site_url('barang/data') ?>" class="badge border text-bg-light">
                            Tampilkan semua
                        </a>
                    </div>
                </div>
            </div>
            <div class="card-body p-0" id="data_brg">
               
            </div>
        </div>
    </div>
</div>

<form method="POST" class="modal fade" id="modal">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Tambah Data
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>

            <div class="modal-body">
                <input type="hidden" name="id" value="0">
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">SKU</strong>
                        <small class="text-muted">
                            Masukan atau klik <i class="fa fa-repeat mx-1"></i> untuk generate kode barang
                        </small>
                    </div>                    
                    <div class="col-sm-8">
                        <div class="input-group">
                            <input type="text" required 
                                   class="form-control" 
                                   autocomplete="off" 
                                   name="kode" 
                            >
                            <a href="" class="btn btn-light border btn-generate">
                                <i class="fa fa-repeat"></i>
                            </a>    
                        </div>
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Nama Barang </strong>
                        <small class="text-muted">
                            Masukan nama barang
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text"required 
                               class="form-control" 
                               name="nama" 
                        >
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">
                            Satuan 
                            <small class="fa fa-info-circle ms-1 text-muted"
                                    data-bs-toggle="tooltip" data-bs-aligment="top"
                                    title="Satuan wajib dipilih jika ingin mengaktifkan multi satuan"
                            ></small>
                        </strong>
                        <small class="text-muted">
                            Tentukan stok dan pilih satuan barang
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <div class="row">
                            <div class="col-sm-4 stok_brg">
                                <input type="number" name="stok" placeholder="Stok"
                                       class="form-control nochange text-center" 
                                >
                            </div>
                                            
                            <div class="col-sm-8 satuan_brg">
                                <select class="form-select select2-nosrc" name="id_satuan">
                                    <option value disabled selected>Pilih</option>
                                    
                                    <?php 
                                        $this -> db -> order_by('nama');
                                        $get_satuan = $this -> db -> get('satuan') -> result();
                                        foreach($get_satuan as $satuan) {
                                            echo '
                                                <option value="'.$satuan -> id.'">
                                                    '.$satuan -> nama.'
                                                </option>
                                            ';
                                        }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Harga Beli </strong>
                        <small class="text-muted">
                            Tentukan harga beli barang
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text" required 
                               inputmode="numeric" name="harga_beli" 
                               class="form-control form_uang" 
                               autocomplete="off" 
                        >
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">
                            Harga Jual 
                            <small class="fa fa-info-circle ms-1 text-muted"
                                   data-bs-toggle="tooltip" data-bs-aligment="top"
                                   title="Harga jual tidak boleh kurang dari harga beli"
                            ></small>
                        </strong>
                        <small class="text-muted">
                            Tentukan harga jual barang
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <input type="text" required 
                               class="form-control form_uang" 
                               inputmode="numeric" name="harga_jual" 
                               autocomplete="off" 
                        >
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Kategori</strong>
                        <small class="text-muted">
                            Pilih Kategori Barang
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <select class="form-select select2-nosrc" name="id_kategori">
                            <option value disabled selected>Pilih</option>
                            
                            <?php 
                                $this -> db -> order_by('nama');
                                $get_kategori = $this -> db -> get('kategori') -> result();
                                foreach($get_kategori as $kategori) {
                                    echo '
                                        <option value="'.$kategori -> id.'">
                                            '.$kategori -> nama.'
                                        </option>
                                    ';
                                }
                            ?>
                        </select>
                        
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Supplier</strong>
                        <small class="text-muted">
                            Pilih supplier Barang
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <select class="form-select select2-nosrc" name="id_supplier">
                            <option value disabled selected>Pilih</option>
                            
                            <?php 
                                $this -> db -> order_by('nama');
                                $get_supplier = $this -> db -> get('supplier') -> result();
                                foreach($get_supplier as $supplier) {
                                    echo '
                                        <option value="'.$supplier -> id.'">
                                            '.$supplier -> nama.'
                                        </option>
                                    ';
                                }
                            ?>
                        </select>
                        
                    </div>
                </div>
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">
                            Tgl Kadaluarsa
                            <small class="fa fa-info-circle ms-1 text-muted"
                                   data-bs-toggle="tooltip" data-bs-aligment="top"
                                   title="Contoh: 29/09/2050"
                            ></small>
                        </strong>
                        <small class="text-muted">
                            Aktifkan dan tentukan tgl kadaluarsa
                        </small>
                    </div>
                    <div class="col-sm-8">
                        <div class="input-group">
                            <div class="btn btn-light border ">
                                <input type="checkbox" id="is_exp" 
                                       name="is_exp" value="0"
                                       class="form-check-input" 
                                >
                            </div>
                            <input type="text" readonly 
                                   class="form-control" 
                                   name="tgl_kadaluarsa" 
                            >
                        </div>
                    </div>
                </div>        
            
                <div class="row mb-4">
                    <div class="col-sm-4 mb-2">
                        <strong class="d-block">Retur Barang</strong>
                        <small class="text-muted">
                            Aktifkan jika barang dapat dikembalikan
                        </small>
                    </div>                    
                    <div class="col-sm-8">
                        <div class="form-check form-switch">
                            <input class="form-check-input" value="0"
                                   type="checkbox" role="switch" 
                                   id="is_retur" name="is_retur" 
                            >
                            <label class="form-check-label label-sw" 
                                    for="is_retur"
                            ></label>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer border-0">
                <button class="btn btn-primary px-5">
                    Simpan
                </button>
                <a href="javascript:void(0)" 
                   class="btn btn-light" 
                   data-bs-dismiss="modal"
                >
                    Batal
                </a>
            </div>
        </div>
    </div>
</form>

<form method="POST" class="modal fade" id="modal_multi_satuan" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            
        </div>
    </div>
</form>

<form method="POST" class="modal fade" id="modal_grosir" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            
        </div>
    </div>
</form>

<form method="POST" enctype="multipart/form-data" class="modal fade" id="modal_import" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Import data barang
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body ">
                <div class="msg warning">
                    <span class="d-block mb-1">
                        File yang diimport harus sesuai dengan template yang sudah disediakan.
                    </span>
                    <a href="javascript:void(0)" onclick="redirect('berkas/template_import_data_barang.xlsx')" class="badge bg-white text-warning mt-1">
                        <i class="fa fa-download me-1"></i>
                        Download Template
                    </a>
                </div>
                <div class="dashed rounded px-4 py-5 text-center o-hidden position-relative">
                    <label for="">
                        <i class="fa fa-upload fa-2x d-block text-muted mb-4"></i>
                        <span>Pilih atau tempelkan file excel disini</span>
                    </label>
                    <input type="file" id="import_file_inp" name="file" accept=".xlsx, .xls">
                </div>
                
            </div>
            <div class="modal-footer border-0 d-none">
                <div class="msg light border w-100" style="z-index: 1">
                    <span class="d-block" id="file_upload_name">
                        -
                    </span>
                    <small class="text-muted">
                        File size: <span id="file_upload_size">0</span> KB
                    </small>

                    <a href="javascript:void(0)" class="close">
                        <i class="fa fa-times"></i>
                    </a>
                </div>
                <button class="btn btn-primary py-3 w-100">
                    <strong id="save_import">
                        Simpan
                    </strong>
                </button>
            </div>
        </div>
    </div>
</form>

<div class="modal fade" id="modal_barcode">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barcode
                        </strong>
                    </h5>
                    <small>
                        Cetak Barcode
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body">
                
            </div>
        </div>
    </div>
</div>

<?php if($this -> session -> mart_demo == 0) : ?>
    <div class="modal fade" id="modal_scan_kamera">
        <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <div>
                        <h5 class="modal-header-title mb-0">
                            <strong>
                                Barang
                            </strong>
                        </h5>
                        <small>
                            Scan dengan kamera
                        </small>
                    </div>
                    <a href="javascript:void(0)" 
                        class="btn-close" 
                        data-bs-dismiss="modal"
                    ></a>
                </div>
                <div class="modal-body">
                    <div id="qr-reader" class="w-100 bg-light"></div>
                    <div class="form-check text-start mt-3">
                        <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_cam_modal">
                        <label class="form-check-label" for="autoclose_cam_modal">
                            Tutup otomatis 
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>

<div class="modal fade" id="modal_scanner">
    <div class="modal-dialog modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Scan dengan scanner
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body text-center">
                <div class="border p-4 bg-light rounded">
                    <img src="<?= base_url('assets/img/scanner.png') ?>">
                    <div class="mt-3" style="position: relative;overflow:hidden">
                        Arahkan scanner ke barcode
                        <input type="text" id="inp_scanner" inputmode="none">
                    </div>
                </div>
                <div class="form-check text-start mt-3">
                    <input class="form-check-input autoclose" type="checkbox" value="" id="autoclose_modal">
                    <label class="form-check-label" for="autoclose_modal">
                        Tutup otomatis 
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_aktivitas">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-fullscreen-sm-down">
        <div class="modal-content">
            <div class="modal-header border-0">
                <div>
                    <h5 class="modal-header-title mb-0">
                        <strong>
                            Barang
                        </strong>
                    </h5>
                    <small>
                        Aktivitas stok
                    </small>
                </div>
                <a href="javascript:void(0)" 
                    class="btn-close" 
                    data-bs-dismiss="modal"
                ></a>
            </div>
            <div class="modal-body p-0">
                <div class="px-3 pt-3">
                    <div class="row justify-content-between mb-2">
                        <div class="col-sm-2 mb-2">
                            <select class="form-select w-px-80 select2-nosrc" id="limiter">
                                <option>10</option>
                                <option selected>25</option>
                                <option>50</option>
                                <option>100</option>
                            </select>
                        </div>
                        <div class="col-sm-4 mb-2 text-end">
                            <button class="btn btn-primary">
                                <i class="fa fa-plus-circle me-1"></i>
                                Masuk
                            </button>
                            <button class="btn btn-danger">
                                <i class="fa fa-minus-circle me-1"></i>
                                Keluar
                            </button>
                        </div>
                    </div>
                </div>

                <div id="list_riwayat">
                    
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url('assets/vendor/scanner/html5-qrcode.min.js') ?>"></script>
<script>
    $(function() {
        load_data(1);
        
    });

    function load_data(page) {
        $.post({
            url: base_url + 'proses/load_brg',
            data: {
                filter: $('#filter_brg_inp').val(),
                limit: $('#limit_data').val(),
                cari: $('#src_brg').val(),
                active: page,
            },
            dataType: 'html',
            success: data => {
                $('#data_brg').html(data);
                tooltip();
            }
        })
    }

    function cek_data(code, mode) {
        $.post({
            url: base_url + 'proses/cek_data',
            data: {code:code},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    $('#src_brg').val(json.data.kode).change();
                    $('.msg_filter').removeClass('d-none');
                    
                    if($('#autoclose_cam_modal, autoclose_modal').is(':checked')) {
                        $('.modal').modal('hide');
                    }

                    toast({
                        icon: 'success',
                        title: json.msg
                    });

                } else if(json.success == 0) {
                    toast({
                        icon: 'error',
                        title: json.msg
                    });

                }

                if(mode == 'scanner') {
                    $('#inp_scanner').val('');
                }
            }
        })
    }

    function modal_barcode(id) {
        $.post({
            url: base_url + 'proses/modal_barcode',
            data: {
                id: id
            },
            dataType: 'html',
            success: data => {
                $('#modal_barcode').modal('show').find('.modal-body').html(data);
            }
        })
    }

    function generate_code() {
        let code            = 899;
        let kodePerusahaan  = 1999;
        let kodeProduk      = Math.random() * 99999;
        let rand            = Math.floor(kodeProduk);

        return "" + code + "" + "" + kodePerusahaan + "" + "" + rand + "";
    }

    function hps_brg(id, nama) {
        swal_hps_item.fire().then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/hps_brg',
                    data: {
                        id:id, 
                        nama:nama
                    },
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data(1);
                        }
                    }
                })
            }
        });
    }
    
    function edit_brg(id) {
        $('.stok_brg').addClass('d-none');
        $('.btn-generate').addClass('d-none');
        $('.satuan_brg').removeClass('col-sm-8').addClass('col-sm-12');

        $.post({
            url: base_url + 'proses/get_brg',
            data: {id: id},
            dataType: 'json',
            success: json => {
                if(json.success == 1) {
                    $('#modal').modal('show');
                    $('[name="id"]').val(json.data.id);
                    $('[name="kode"]').val(json.data.kode);
                    $('[name="nama"]').val(json.data.nama);
                    $('[name="stok"]').val(json.data.stok);
                    $('[name="id_satuan"]').val(json.data.id_satuan).change();
                    $('[name="harga_beli"]').val(form_uang(String(json.data.harga_beli)));
                    $('[name="harga_jual"]').val(form_uang(String(json.data.harga_jual)));
                    $('[name="id_kategori"]').val(json.data.id_kategori).change();
                    $('[name="id_supplier"]').val(json.data.id_supplier).change();

                    if(json.data.tgl_kadaluarsa) {
                        $('#is_exp').prop('checked', true)
                        $('[name="tgl_kadaluarsa"]').val(json.data.tgl_kadaluarsa)
                                                    .prop({
                                                        type: 'date',
                                                        readonly: false
                                                    })

                    } else {
                        $('#is_exp').prop('checked', false);
                        $('[name="tgl_kadaluarsa"]').val('')
                                                    .prop({
                                                        type: 'text',
                                                        readonly: true
                                                    })
                    }

                    json.data.is_retur == 1 ? $('[name="is_retur"]').prop('checked', true) 
                                            : $('[name="is_retur"]').prop('checked', false);
                }
            }
        })
    }

    function riwayat_stok(id) {
        $('#modal_aktivitas').modal('show');
        load_riwayat(id)
    }

    function load_riwayat(id) {
        $.post({
            url: base_url + 'proses/load_riwayat',
            data: {
                id: id,
                active: 1 
            },
            success: data => {
                $('#list_riwayat').html(data);
                select2();
            }
        })
    }

    function open_scanner(scanner) {
        $('#modal_scanner').modal('show')
    }

    function reset_import() {
        $('#modal_import .modal-footer').addClass('d-none');
        $('#import_file_inp').val('');
    }

    function reset_modal() {
        $('#modal').trigger('reset');
        $('#modal .select2-nosrc').val('')
                                  .change();
        $('[name="tgl_kadaluarsa"]').prop({
            type: 'text',
            readonly: true
        });
        $('[name="id"]').val(0);
        $('.btn-generate').removeClass('d-none');
    }

    function multi_satuan(id, satuan) {
        if(satuan != '0') {
            $.post({
                url: base_url + 'proses/load_multi_satuan',
                data: {id:id},
                dataType: 'html',
                success: data => {
                    $('#modal_multi_satuan').modal('show').find('.modal-content').html(data);
                }
            })

        } else {
            toast({
                icon: 'error',
                title: 'Satuan utama belum dipilih'
            })
        }
        
    }

    function harga_grosir(id, satuan) {
        if(satuan != '0') {
        $.post({
                url: base_url + 'proses/load_grosir',
                data: {id:id},
                dataType: 'html',
                success: data => {
                    $('#modal_grosir').modal('show').find('.modal-content').html(data);
                    load_grosir_list();
                }
            })
        } else {
            toast({
                icon: 'error',
                title: 'Satuan utama belum dipilih'
            })
        }
        
    }

    function load_grosir_list() {
        $.post({
            url: base_url + 'proses/load_grosir_list',
            data: {
                id: $('#grosir_brg').val(),
                satuan: $('#grosir_satuan_brg').val()
            },
            dataType: 'html',
            success: data => {
                $('.grosir_data').html(data);
            }
        })
    }

    $(document).on('change', '#limit_data, #src_brg', function() {
        load_data(1);
    })
    
    $(document).on("click", '#is_exp', function(e) {
        if($(this).is(':checked')) {
            $('[name="tgl_kadaluarsa"]').attr({
                type: 'date',
                readonly: false
            });
        } else {
            $('[name="tgl_kadaluarsa"]').attr({
                type: 'text',
                readonly: true
            }).val('');
        }
    });

    $(document).on('click', '.btn-generate', function(e) {
        e.preventDefault();
        $('[name="kode"]').val(generate_code);
    });

    $(document).on('click', '#tambah', function() {
        $('#modal').modal('show');
        $('.stok_brg').removeClass('d-none');
        $('.satuan_brg').removeClass('col-sm-12').addClass('col-sm-8');
        reset_modal();
    });

    $(document).on('click', '.btn_export_data', function() {
        <?php if($this -> session -> mart_demo == 1) : ?>
            swal_hps_item.fire({
                icon: 'warning',
                title: 'Catatan',
                text: 'Fitur ini tidak tersedia diakun demo.',
                confirmButtonText: 'Tanya developer'
            }).then(res => {
                if(res.isConfirmed) {
                    window.open('https://wa.me/6282236676620');
                }
            })

        <?php else: ?> 

            swal_simpan.fire({
                text: 'Aksi ini akan mengunduh data barang dalam bentuk excel',
                confirmButtonText: 'Export'
            }).then(res => {
                if(res.isConfirmed) {
                    redirect('excel/export')
                }
            })

        <?php endif ?>
    });

    $(document).on('change', '#import_file_inp', function() {
       $('#modal_import .modal-footer').removeClass('d-none');
       let files = this.files[0];
       
       $('#file_upload_name').text(files.name);
       $('#file_upload_size').text(Math.round(files.size / 1000));
       $('#modal_import .modal-footer .msg').show();
    });

    $(document).on('click', '.close', function() {
        reset_import();
    });
    
    $(document).on('hidden.bs.modal', '#modal_import', function() {
        reset_import();
    });

    $(document).on('submit', '#modal_import', function(e) {
        e.preventDefault();

        <?php if($this -> session -> mart_demo == 1) : ?>
            swal_hps_item.fire({
                icon: 'warning',
                title: 'Catatan',
                text: 'Fitur ini tidak tersedia diakun demo.',
                confirmButtonText: 'Tanya developer'
            }).then(res => {
                if(res.isConfirmed) {
                    window.open('https://wa.me/6282236676620');
                }
            })

        <?php else: ?> 

            $('#save_import').text('Menyimpan...').closest('button').addClass('disabled');
            
            $.post({
                url: base_url + 'excel/import', 
                data: new FormData(this),
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(json) {
                    if(json.success == 1) {
                        $('#save_import').text('Memuat ulang...')
                        toast({
                            title: json.msg,
                            icon: 'success',
                        })

                        setTimeout(() => {
                            location.reload();
                        }, 1200);

                    } else {
                        $('#save_import').text('Simpan').closest('button').removeClass('disabled');
                        toast({
                            title: json.msg,
                            icon: 'error'
                        })
                    }
                },
                error: function(xhr, status, error) {
                    $('#save_import').text('Simpan').closest('button').removeClass('disabled');
                    toast({
                        title: 'Ada yang salah, coba lagi',
                        icon: 'error'
                    })
                }
            });

        <?php endif ?>
    });

    $(document).on('click', '#print_all_barcode', function() {
        window.open(base_url + 'barang/barcode?jml=1&id=0');
    });

    $(document).on('click', '#btn_barcode_print', function() {
        let id  = $(this).data('id');
        let jml = $('#inp_jml_print').val();
        window.open(base_url + 'barang/barcode?jml=' + jml + '&id=' + id);
    });

    $(document).on('click', '.show_all', function() {
        $('.msg_filter').addClass('d-none');
        $('#src_brg').attr('readonly', false).val('').change();
    });

    $(document).on('click', '.btn_import_data', function() {
        $('#modal_import').modal('show');
    });

    $(document).on('change', '#inp_scanner', function() {
        cek_data(this.value, 'scanner')
    });

    $(document).on('shown.bs.modal', '#modal_scan_kamera', function() {
        $('#html5-qrcode-button-camera-stop').click();
        setTimeout(() => {
            $('#html5-qrcode-button-camera-start').click();
            
        }, 0);
    });

    $(document).on('shown.bs.modal', '#modal_scanner', function() {
        $(document).on('keydown', function(e) {
            if(e.which == 13) {
                $('#inp_scanner').focus();
            }
        })
    })

    $(document).on('click', '#is_multi_satuan', function() {
        let active, id;
        id = $(this).data('id');
        
        if($(this).is(':checked')) {
            $('.multi_satuan_data, .btn_add_multi, .btn_multi_aksi').removeClass('d-none');
            active = 1;
        } else {
            $('.multi_satuan_data, .btn_add_multi, .btn_multi_aksi').addClass('d-none');
            active = 0;
        }

        $.post({
            url: base_url + 'proses/toggle_multi_satuan',
            data: {
                id:id,
                active:active
            }
        })
    })

    $(document).on('click', '.btn_add_multi', function(e) {
        e.preventDefault();
        let item = $('.multi_satuan_list').html();
        $('.multi_satuan_data').append(item).find('input, select').attr('required', true);
    })

    $(document).on('click', '.btn_hps_multi', function(e) {
        e.preventDefault();
        let id = $(this).data('id');

        if(id > 0) {
            $.post({
                url: base_url + 'proses/hps_multi_satuan',
                data: {id:id},
                success: res => {
                    if(res == '') {
                        $(this).closest('.row').remove();
                    }
                }
            })

        } else {
            $(this).closest('.row').remove();
        }

    })

    $(document).on('submit', '#modal_multi_satuan', function(e) {
        e.preventDefault();
        $('.btn_multi_aksi button').addClass('disabled').text('Menyimpan...');

        swal_simpan.fire({
            text: 'Anda akan menyimpan semua perubahan data multi satuan'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_multi_satuan',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            $('.btn_multi_aksi button').text('Memuat ulang...');
                            toast({
                                title: json.msg,
                                icon: 'success'
                            });
        
                            setTimeout(() => {
                                location.reload();
                            }, 1200);
        
                        } else {
                            $('.btn_multi_aksi button').removeClass('disabled').text('Simpan');
                            toast({
                                title: json.msg,
                                icon: 'error'
                            })
                        }
                    } 
                })
            } else {
                $('.btn_multi_aksi button').removeClass('disabled').text('Simpan');
            }
        })

    })

    $(document).on('click', '#is_grosir', function() {
        let active, id;
        id = $(this).data('id');
        
        if($(this).is(':checked')) {
            $('.grosir_data, .btn_add_grosir, .btn_grosir_aksi').removeClass('d-none');
            active = 1;
        } else {
            $('.grosir_data, .btn_add_grosir, .btn_grosir_aksi').addClass('d-none');
            active = 0;
        }

        $.post({
            url: base_url + 'proses/toggle_grosir',
            data: {
                id:id,
                active:active
            }
        })
    });

    $(document).on('click', '.btn_add_grosir button', function(e) {
        e.preventDefault();
        let item = $('.grosir_data_list').html();
        $('.grosir_data').append(item)
                        .find('input')
                        .attr('required', true);
        $('.grosir_data_list input').attr('required', false);
    })

    $(document).on('change', '#grosir_satuan_brg', function(e) {
        load_grosir_list();
    });

    $(document).on('click', '.btn_hps_grosir', function(e) {
        e.preventDefault();
        let id = $(this).data('id');

        if(id > 0) {
            $.post({
                url: base_url + 'proses/hps_grosir',
                data: {id:id},
                success: res => {
                    if(res == '') {
                        $(this).closest('.row').remove();
                    }
                }
            })

        } else {
            $(this).closest('.row').remove();
        }

    })

    $(document).on('submit', '#modal_grosir', function(e) {
        e.preventDefault();
        $('.btn_grosir_aksi button').addClass('disabled').text('Menyimpan...');

        swal_simpan.fire({
            text: 'Anda akan menyimpan semua perubahan data grosir barang'
        }).then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_grosir',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            $('.btn_grosir_aksi button').text('Memuat ulang...');
                            if(json.msg == 'update-0') {
                                toast({
                                    title: 'Tidak ada perubahan data',
                                    icon: 'info'
                                });
                                $('.btn_grosir_aksi button').removeClass('disabled').text('Simpan');

                            } else {
                                toast({
                                    title: json.msg,
                                    icon: 'success'
                                });

                                setTimeout(() => {
                                    location.reload();
                                }, 1200);
                            }
        
                        } else {
                            $('.btn_grosir_aksi button').removeClass('disabled').text('Simpan');
                            toast({
                                title: json.msg,
                                icon: 'error'
                            })
                        }
                    } 
                })
            } else {
                $('.btn_grosir_aksi button').removeClass('disabled').text('Simpan');
            }
        })

    });

    $(document).on('submit', '#modal', function(e) {
        e.preventDefault();
        let form = $(this);
        swal_simpan.fire().then(res => {
            if(res.isConfirmed) {
                $.post({
                    url: base_url + 'proses/submit_barang',
                    data: form.serialize(),
                    dataType: 'json',
                    success: json => {
                        if(json.success == 1) {
                            load_data(1);
                            $('.modal').modal('hide');

                            if(json.msg == 'edit-0') {
                                toast({
                                    icon: 'info',
                                    title: 'Tidak ada perubahan data'
                                })
                            } else {
                                toast({
                                    icon: 'success',
                                    title: json.msg
                                })
                            }

                        } else {
                            toast({
                                icon: 'error',
                                title: json.msg
                            })
                        }
                    }
                })
            }
        });
    })

</script>