<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Barcode</title>

    <style>
        * {
            box-sizing: border-box;
        }
        body, p {
            padding: 0;
            margin: 0;
        }
        .item {
            border: 3px solid #000;
            padding: 7px;
            text-align: center;
            width: 33mm;
        }
        .item img {
            max-width: 33mm;
        }
        p {
            font-size: 12px;
        } 
        @page {
            margin: 0;
        }
        .wrap {
            width: 72mm;
            display: flex;
            flex-wrap: wrap;
            row-gap: 3mm;
            column-gap: 2mm;
        }
    </style>
</head>
<body>
    <div class="wrap">
        <?php 
            if($id > 0) {
                $this -> db -> where('id', $id);
            }
            $toko = $this -> session -> mart_toko;
            $this -> db -> where('id_toko', $toko);
            $barang    = $this -> db -> get('barang') -> result();
            $generator = new Picqer\Barcode\BarcodeGeneratorJPG();
            for($i = 1; $i <= $jml; $i++) :
                foreach($barang as $item) :
        ?>
            <div class="item">
                <?php 
                    echo '<img src="data:image/png;base64,' . 
                    base64_encode($generator -> getBarcode($item -> id, $generator::TYPE_EAN_13, 1, 40)) . 
                    '">';
                ?>
                <p>
                    <?php 
                        echo $item -> kode;
                    ?>
                </p>
            </div>
        <?php endforeach ?>
        <?php endfor ?>
    </div>

    <script>
        setTimeout(function () { window.print(); }, 0);
        window.onload = function () { setTimeout(function () { window.close(); }, 0); }
    </script>
</body>
</html>