<?php

class App_model extends CI_Model {
    public function get_menu() {
        $data['menu'] = get_menu();
        $this -> load -> view('navmenu', $data);  
    }
    
    public function get_app($field = 'semua') {
        $get = $this -> db -> get('app') -> row();  

        if($field == 'semua') {
            return $get;
        } else {
            return $get -> $field;
        }
    }

    public function get_admin($field = 'semua') {
        $id  = $this -> session -> mart_id;  
        $get = $this -> db -> get_where('admin', ['id' => $id]) -> row();

        if($field == 'semua') {
            return $get;

        } else {
            return $get ? $get -> $field : null;
        }
    }

    public function get_init_name() {
        $name = $this -> get_admin('nama');
        $name = str_split($name);
        return $name ? strtoupper($name[0]) : null;
    }

    public function get_toko($id = 'semua', $field = 'semua') {
        if($id == 'semua') {
            return $this -> db -> get('toko') -> result();

        } else {
            $get = $this -> db -> get_where('toko', ['id' => $id]) -> row();

            if($field == 'semua') {
                return $get;
    
            } else {
                $get -> cabang_label = $get -> cabang == 1 ? 'Pusat' : 'Cabang';
                return $get ? $get -> $field : null;
            }
        }
    }

    public function get_toko_aktif($field = 'nama') {
        $id   = $this -> session -> mart_toko;
        $data = $this -> get_toko($id, $field);

        return $data;
    }

    public function get_cabang($tipe = 'default') {
        $toko  = $this -> session -> mart_toko;
        $cabang =  $this -> get_toko($toko, 'cabang');

        if($tipe == 'text') {
            return $cabang == 1 ? 'Pusat' : 'Cabang';
            
        } else {
            return $cabang;
        }
    }

    public function get_barang() {
        $toko = $this -> session -> mart_toko;
        $get  = $this -> db -> get_where('barang', ['id_toko' => $toko]) -> result();
        $new  = [];
        
        foreach($get as $item) {
            $kategori     = $this -> db -> get_where('kategori', ['id' => $item -> id_kategori]) -> row();
            $supplier     = $this -> db -> get_where('supplier', ['id' => $item -> id_supplier]) -> row();
            $satuan_brg   = $this -> db -> get_where('barang_satuan', ['id_brg' => $item -> id, 'jenis' => 1]) -> row();

            if($kategori) {
                $item -> kategori = $kategori -> nama;
            }

            if($supplier) {
                $item -> supplier = $supplier -> nama;
            }

            if($satuan_brg) {
                $satuan = $this -> db -> get_where('satuan', ['id' => $satuan_brg -> id_satuan]) -> row();
                
                $item -> id_satuan  = $satuan -> id;
                $item -> satuan     = $satuan -> nama;
                $item -> stok       = $satuan_brg -> stok;
                $item -> harga_jual = $satuan_brg -> harga_jual;
                $item -> harga_beli = $satuan_brg -> harga_beli;
            }

            $new[] = $item;
        }

        return $new;
    }

    public function get_barang_detail($id) {
        $toko         = $this -> session -> mart_toko;
        $item         = $this -> db -> get_where('barang', ['id' => $id, 'id_toko' => $toko]) -> row();
        $kategori     = $this -> db -> get_where('kategori', ['id' => $item -> id_kategori]) -> row();
        $supplier     = $this -> db -> get_where('supplier', ['id' => $item -> id_supplier]) -> row();
        $satuan_brg   = $this -> db -> get_where('barang_satuan', ['id_brg' => $item -> id, 'jenis' => 1]) -> row();

        if($kategori) {
            $item -> kategori = $kategori -> nama;
        }

        if($supplier) {
            $item -> supplier = $supplier -> nama;
        }

        if($satuan_brg) {
            $satuan = $this -> db -> get_where('satuan', ['id' => $satuan_brg -> id_satuan]) -> row();
            
            $item -> id_satuan  = isset($satuan -> id) ? $satuan -> id : '';
            $item -> satuan     = isset($satuan -> nama) ? $satuan -> nama : '';
            $item -> stok       = $satuan_brg -> stok;
            $item -> harga_jual = $satuan_brg -> harga_jual;

        } else {
            $item -> id_satuan  = null;
            $item -> satuan     = null;
            $item -> stok       = null;
            $item -> harga_jual = null;
        }

        return $item;
    }

    public function get_barang_stok($id, $field = 'semua') {
        $rt     = 0;
        $idtoko = $this -> session -> mart_toko; 
        $get    = $this -> db -> get_where('barang', ['id' => $id, 'id_toko' => $idtoko]) -> row();

        if($get) {
            $barang_satuan = $this -> db -> get_where('barang_satuan', ['id_brg' => $get -> id, 'jenis' => 1]) -> row();
            $satuan        = $this -> db -> get_where('satuan', ['id' => $barang_satuan -> id_satuan]) -> row();
            $satuan         = $satuan ? $satuan : new stdClass();
            $satuan -> nama = isset($satuan -> nama) ? $satuan -> nama : '';

            if($field == 'semua') {
                $rt     = $barang_satuan -> stok . ' ' . $satuan -> nama; 

            } else if($field == 'satuan') {
                $rt     = $satuan -> nama; 

            } else if($field == 'stok') {
                $rt     = $barang_satuan -> stok; 
            } 
        }
        
        return $rt;
    }

    public function update_stok_brg($array = []) {
        if(is_array($array)) {
            $where['id_brg']    = $array['id_brg']; 
            $where['id_toko']   = $array['id_toko'];
            $where['id_satuan'] = $array['id_satuan'];

            $get = $this -> db -> get_where('barang_satuan', $where) -> row();

            $update['stok'] = $array['aksi'] == 'tambah' 
                                ? $get -> stok + $array['qty']
                                : $get -> stok - $array['qty']
            ;

            $this -> db -> update('barang_satuan', $update, $where) -> row();
        }
    }

    public function total_brg_toko() {
        $idtoko = $this -> session -> mart_toko;
        $data   = $this -> db -> get_where('barang', ['id_toko' => $idtoko]) -> num_rows();
        return $data;
    }

    public function total_brg_masuk($jenis = 'semua') {
        $idtoko  = $this -> session -> mart_toko;
        $admin   = $this -> session -> mart_id;
        $level   = $this -> session -> mart_level;
        $today   = date('Y-m-d');

        if($jenis == 'today') {
            $this -> db -> where('DATE(tgl)', $today);
        }

        if($level != 'owner') {
            $this -> db -> where('id_admin', $admin);
        }

        $this -> db -> where('id_toko', $idtoko);
        $this -> db -> where('status', 1);
        $total = $this -> db -> get('riwayat_stok') -> num_rows();

        return $total;
    }

    // public function cek_tf_brg($id) {
    //     $toko = $this -> session -> mart_toko;
    //     $brg  = $this -> db -> get_where('barang', ['id' => $id, 'id_toko' => $toko]) -> row();

    //     $where['id_transfer'] = 0;
    //     $where['kode_brg']      = $brg -> kode;
    //     return $this -> db -> get_where('transfer_detail', $where) -> num_rows();
    // } 

    public function total_brg_terjual($jenis = 'semua') {
        $toko  = $this -> session -> mart_toko;
        $admin = $this -> session -> mart_id;
        $level = $this -> session -> mart_level;
        $date  = date('Y-m-d');
        $total = 0;

        if($level == 'kasir') {
            $this -> db -> where('a.id_admin', $admin);
        }

        if($jenis != 'semua') {
            $this -> db -> where('DATE(tgl)', $date);
        }

        $this -> db -> select('id_jual, b.id, tgl, a.id_admin, a.id_toko');
        $this -> db -> join('penjualan_data b', 'id_jual = b.id');
        $this -> db -> where('a.id_toko', $toko);
        $this -> db -> where('id_jual > ', 0);
        $this -> db -> group_by('a.id_jual');
        $total   = $this -> db -> get('penjualan_detail a') -> num_rows();

        return $total;
    }

    public function get_barang_satuan($id, $jenis = 'semua') {
        if($id) {
            if($jenis != 'semua') {
                $this -> db -> where('jenis', $jenis);
            }
            $toko = $this -> session -> mart_toko;
            $data = $this -> db -> get_where('barang_satuan', ['id_brg' => $id, 'id_toko' => $toko]) -> result();
            $new  = [];
            if($data) {
                foreach($data as $item) {
                    $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                    $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                    $item -> barang = $barang -> nama;
                    $item -> satuan = isset($satuan -> nama) ? $satuan -> nama : '';

                    $new[] = $item;
                }
            }

            return $new;
        }
    }

    public function get_barang_grosir($id, $satuan = '') {
        if($id) {
            $new  = [];
            $toko = $this -> session -> mart_toko;
            $data = $this -> db -> get_where(
                'barang_grosir', 
                [
                    'id_brg'    => $id, 
                    'id_satuan' => $satuan, 
                    'id_toko'   => $toko
                ]
            ) -> result();

            if($data) {
                foreach($data as $item) {
                    $barang = $this -> db -> get_where('barang', ['id' => $id]) -> row();
                    $item -> barang = $barang -> nama;

                    $new[] = $item;
                }
            }

            return $new;
        }
    }

    public function cek_stok_brg($id) {
        return $this -> db -> get_where(
            'barang_satuan', 
            ['id'   => $id]
        ) -> row() -> stok;
    }

    public function jml_stok_kosong($id = 'semua', $jenis = 'semua') {
        $toko = $this -> session -> mart_toko;
        $jml  = 0;
        $stok_utama   = 0;
        $stok_turunan = 0;
        
        if($id != 'semua') {
            $this -> db -> where('id_brg', $id);
        }
        
        $this -> db -> where('id_toko', $toko);
        $this -> db -> where('stok', 0);
        $data  = $this -> db -> get('barang_satuan') -> result();

        foreach($data as $item) {
            $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();

            if($item -> stok == 0) {
                if($barang -> is_multi_satuan == 1 && $item -> jenis == 2) {
                    $stok_turunan++;
                }

                if($item -> jenis == 1) {
                    $stok_utama++;
                }
            }
        }
        
        if($jenis == 1) {
            return $stok_utama;

        } else if($jenis == 2) {
            return $stok_turunan;

        } else {
            return $stok_utama + $stok_turunan;
        }
    }

    public function jml_brg_kadaluarsa($id = 'semua') {
        $toko  = $this -> session -> mart_toko;
        $today = time();
        $jml   = 0;
        
        if($id != 'semua') {
            $this -> db -> where('id', $id);
        }
        
        $this -> db -> where('id_toko', $toko);
        $data  = $this -> db -> get('barang') -> result();

        foreach($data as $item) {
            $kadaluarsa = $item -> tgl_kadaluarsa;
            
            if($kadaluarsa) {
                $kadaluarsa = strtotime($kadaluarsa);

                if($today > $kadaluarsa) {
                    $jml++;
                }
            }
        }
        
        return $jml;
    }

    public function jml_transaksi($filter = 'semua') {
        $toko  = $this -> session -> mart_toko;
        $admin  = $this -> session -> mart_id;
        $level  = $this -> session -> mart_level;
        $today = date('Y-m-d');
        
        if($filter == 'hari_ini') {
            $this -> db -> where('DATE(tgl)', $today);
        }
        
        if($level != 'owner') {
            $this -> db -> where('id_admin', $admin);
        }
        
        $this -> db -> where('id_toko', $toko);
        $jml  = $this -> db -> get('riwayat_transaksi') -> num_rows();

        return $jml;
    }

    public function get_detail_belanja($kode) {
        $data   = $this -> db -> get_where('penjualan_data', ['kode' => $kode]) -> row();

        if($data) {
            $detail = $this -> db -> get_where('penjualan_detail', ['id_jual' => $data -> id]) -> result();
            $admin  = $this -> db -> get_where('admin', ['id' => $data -> id_admin]) -> row();
            $plg    = $this -> db -> get_where('pelanggan', ['id' => $data -> id_plg]) -> row();
            $new    = [];
    
            $data -> tgl   = tgl(date('d M Y H:i', strtotime($data -> tgl))) . ' WIB';
            $data -> plg   = $data -> id_plg == 0 ? 'Umum' : $plg -> nama;
            $data -> admin = isset($admin -> nama) ? $admin -> nama : '-';
    
            foreach($detail as $item) {
                if($item -> qty > 0) {
                    $satuan = $this -> db -> get_where('satuan', ['id' => $item -> id_satuan]) -> row();
                    $barang = $this -> db -> get_where('barang', ['id' => $item -> id_brg]) -> row();
                    $item -> satuan = isset($satuan -> nama) ? $satuan -> nama : '';
                    $item -> barang = isset($barang -> nama) ? $barang -> nama : '<em>Barang dihapus</em>';
                    $item -> is_retur = isset($barang -> is_retur) ? $barang -> is_retur : 0;
                    $new[] = $item;
                }
            }
    
            $data -> belanjaan = $new;
        }

        return ($data);
    }

    public function get_jml_brg_beli($id) {
        return $this -> db -> get_where('pembelian_detail', ['id_beli' => $id]) -> num_rows();
    } 

    public function get_total_beli($id) {
        $data = $this -> db -> get_where('pembelian_detail', ['id_beli' => $id]) -> result();
        $total = 0;

        foreach($data as $item) {
            $total += $item -> qty * $item -> harga_beli;
        }

        return $total;
    } 

    public function get_jml_brg_jual($id) {
        $this -> db -> where('qty > ', 0);
        return $this -> db -> get_where('penjualan_detail', ['id_jual' => $id]) -> num_rows();
    } 

    public function get_total_jual($id) {
        $where = ['id_jual' => $id];
        $data = $this -> db -> get_where('penjualan_detail', $where) -> result();
        $total = 0;

        foreach($data as $item) {
            $total += $item -> qty * $item -> harga_jual;
        }

        return $total;
    } 

    public function get_keranjang() {
        $where['id_toko']  = $this -> session -> mart_toko;
        $where['id_admin'] = $this -> session -> mart_id;
        $where['id_jual'] = 0;

        return $this -> db -> get_where('penjualan_detail', $where) -> result();
    }

    public function get_stok_opname() {
        $where['id_toko']   = $this -> session -> mart_toko;
        $where['id_admin']  = $this -> session -> mart_id;
        $where['id_opname'] = 0;

        return $this -> db -> get_where('opname_detail', $where) -> result();
    }

    public function jml_brg_opname($id) {
        $where['id_opname'] = $id;

        return $this -> db -> get_where('opname_detail', $where) -> num_rows();
    }
    
    public function get_stok_valid($id) {
        $where['id_opname'] = $id;
        $valid   = 0;

        $get = $this -> db -> get_where('opname_detail', $where) -> result();

        foreach($get as $item) {
            if($item -> stok_sistem == $item -> stok_fisik || $item -> stok_fisik == 0) {
                $valid++;
            } 
        }

        return $valid;
    }
    
    public function get_stok_invalid($id) {
        $where['id_opname'] = $id;
        $valid   = 0;

        $get = $this -> db -> get_where('opname_detail', $where) -> result();

        foreach($get as $item) {
            if($item -> stok_sistem != $item -> stok_fisik && $item -> stok_fisik != 0) {
                $valid++;
            } 
        }

        return $valid;
    }

    public function cek_brg_keranjang($id) {
        $toko = $this -> session -> mart_toko;
        $this -> db -> where('id_toko', $toko);
        $this -> db -> where('id_jual', 0);
        $this -> db -> where('id_brg', $id);
        return $this -> db -> get('penjualan_detail') -> num_rows();
    }

    public function total_pemasukan_today() {
        $toko  = $this -> session -> mart_toko;
        $today = date('Y-m-d');
        $this -> db -> select('detail.id_jual, qty, harga_jual');
        $this -> db -> from('penjualan_data data');
        $this -> db -> join('penjualan_detail detail', 'data.id = detail.id_jual');
        $this -> db -> where('data.id_toko', $toko);

        $this -> db -> where('DATE(data.tgl)', $today);
       
        $get_jual   = $this -> db -> get() -> result();
        $total_jual = 0;

        foreach($get_jual as $jual) {
            $total_jual += $jual -> qty * $jual -> harga_jual;
        }

        return $total_jual;
    }

    public function tambah_aktivitas($ket) {
        $usrid = $this -> session -> mart_id;
        $data = [
            'id_admin'   => $usrid,
            'tgl'        => date('Y-m-d H:i:s'),
            'keterangan' => $ket
        ];
        $this -> db -> insert('aktivitas', $data);
        return true;
    }

    public function pagination($pagination) {
        if($pagination['max_page'] > 2) {
            $func = isset($pagination['func']) ? $pagination['func'] : 'load_data';
            $prev = $pagination['active'] - 1;
            $next = $pagination['active'] + 1;
            
            $disabled_prev = $pagination['active'] < 2 ? 'disabled' : null;
            $disabled_next = $pagination['active'] >= $pagination['max_page'] - 1 ? 'disabled' : null;

            $total_next = ($pagination['max_page'] - $pagination['active']) - 1;
            $total_next = $total_next > 0 ? '('.$total_next.')' : null;

            $html = '
                <div class="pagination-group">
                    <button class="btn btn-secondary rounded-0 rounded-bottom px-4 '.$disabled_prev.'" id="prev_page" onclick="'.$func.'('.$prev.')">
                        Sebelumnya
                    </button>
                    
                    <button class="btn btn-primary rounded-0 rounded-bottom px-4 '.$disabled_next.'" id="next_page"  onclick="'.$func.'('.$next.')">
                        Lainnya 
                        <span id="jml_page">'.$total_next.'</span>
                    </button>
                </div>
            ';  
        }

        return isset($html) ? $html : '';
    }
    
}

// Model App
// Kode ini dibuat dan dikembangkan oleh codelingker