<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {
	public function index() {		
		$this -> load -> view('login');
	}
	
	public function proses() {		
		$input = $this -> input -> post(null, TRUE);
		if(empty($input['email'])) {
			echo json_encode(['success' => 0, 'msg' => 'empty-username']);

		} else if(empty($input['password'])) {
			echo json_encode(['success' => 0, 'msg' => 'empty-password']);

		} else if (!filter_var($input['email'], FILTER_VALIDATE_EMAIL)) {
			echo json_encode(['success' => 0, 'msg' => 'invalid-email']);

		} else {
			$get = $this -> db -> get_where('admin', ['email' => $input['email']]) -> row();
			if(empty($get)) {
				echo json_encode(['success' => 0, 'msg' => 'akun-0']);
				
			} else if(!password_verify($input['password'], $get -> password)) {
				echo json_encode(['success' => 0, 'msg' => 'invalid-password']);
				
			} else {
				$set['mart_id']    = $get -> id;
				$set['mart_email'] = $get -> email;
				$set['mart_nama']  = $get -> nama;
				$set['mart_level'] = $get -> level;
				$set['mart_toko']  = $get -> id_toko;
				$set['mart_demo']  = $get -> akun_demo;
				$this -> session -> set_userdata($set); 

				echo json_encode(['success' => 1]);
			}
		}
	}
}

// Controller Login
// Kode ini dibuat dan dikembangkan oleh codelingker