<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan extends CI_Controller {
	public function __construct() {
		parent::__construct();
		cek_login();
	}

	public function stok($cetak = false) {
		akses('admin');
		if($cetak) {
			$conf = [
				'title' => 'Cetak Laporan Stok'
			];
			$this -> load -> view('laporan/stok/cetak', $conf);
			
		} else {
			$conf = [
				'title' => 'Laporan stok'
			];
			
			$this -> layout -> load('layout', 'laporan/stok/index', $conf);
		}
	}

	public function pembelian($cetak = false, $start = null, $end = null) {
		akses('admin');
		if($cetak) {
			$filter['start_date'] = $start;
			$filter['end_date']   = $end;
			$conf = [
				'title' => 'Cetak Laporan pembelian',
				'input' => $filter
 			];
			$this -> load -> view('laporan/pembelian/cetak', $conf);
			
		} else {
			$conf = [
				'title' => 'Laporan pembelian'
			];
			
			$this -> layout -> load('layout', 'laporan/pembelian/index', $conf);
		}
	}

	public function penjualan($cetak = false, $start = null, $end = null) {
		akses('kasir');
		if($cetak) {
			$filter['start_date'] = $start;
			$filter['end_date']   = $end;
			$conf = [
				'title' => 'Cetak Laporan Penjualan',
				'input' => $filter
 			];
			$this -> load -> view('laporan/penjualan/cetak', $conf);
			
		} else {
			$conf = [
				'title' => 'Laporan penjualan'
			];
			
			$this -> layout -> load('layout', 'laporan/penjualan/index', $conf);
		}
	}

	public function retur($cetak = false, $start = null, $end = null) {
		akses('kasir');
		if($cetak) {
			$filter['start_date'] = $start;
			$filter['end_date']   = $end;
			$conf = [
				'title' => 'Cetak Laporan retur',
				'input' => $filter
 			];
			$this -> load -> view('laporan/retur/cetak', $conf);
			
		} else {
			$conf = [
				'title' => 'Laporan retur'
			];
			
			$this -> layout -> load('layout', 'laporan/retur/index', $conf);
		}
	}
	
	public function opname($cetak = false, $start = null, $end = null) {
		if($cetak) {
			$filter['start_date'] = $start;
			$filter['end_date']   = $end;
			$conf = [
				'title' => 'Cetak Laporan opname',
				'input' => $filter
 			];
			$this -> load -> view('laporan/opname/cetak', $conf);
			
		} else {
			$conf = [
				'title' => 'Laporan opname'
			];
			
			$this -> layout -> load('layout', 'laporan/opname/index', $conf);
		}
	}

	public function keuangan($cetak = false, $start = null, $end = null) {
		akses('kasir');
		if($cetak) {
			$filter['start_date'] = $start;
			$filter['end_date']   = $end;
			$conf = [
				'title' => 'Cetak Laporan keuangan',
				'input' => $filter
 			];
			$this -> load -> view('laporan/keuangan/cetak', $conf);
			
		} else {
			$conf = [
				'title' => 'Laporan keuangan'
			];
			
			$this -> layout -> load('layout', 'laporan/keuangan/index', $conf);
		}
	}

}

// Controller Laporan
// Kode ini dibuat dan dikembangkan oleh codelingker